@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.relay.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Description of a namespace resource.
 * @property createdAt The time the namespace was created.
 * @property id Resource ID.
 * @property location Resource location.
 * @property metricId Identifier for Azure Insights metrics.
 * @property name Resource name.
 * @property privateEndpointConnections List of private endpoint connections.
 * @property provisioningState Provisioning state of the Namespace.
 * @property publicNetworkAccess This determines if traffic is allowed over public network. By default it is enabled.
 * @property serviceBusEndpoint Endpoint you can use to perform Service Bus operations.
 * @property sku SKU of the namespace.
 * @property status Status of the Namespace.
 * @property systemData The system meta data relating to this resource.
 * @property tags Resource tags.
 * @property type Resource type.
 * @property updatedAt The time the namespace was updated.
 */
public data class GetNamespaceResult(
    public val createdAt: String,
    public val id: String,
    public val location: String,
    public val metricId: String,
    public val name: String,
    public val privateEndpointConnections: List<PrivateEndpointConnectionResponse>? = null,
    public val provisioningState: String,
    public val publicNetworkAccess: String? = null,
    public val serviceBusEndpoint: String,
    public val sku: SkuResponse? = null,
    public val status: String,
    public val systemData: SystemDataResponse,
    public val tags: Map<String, String>? = null,
    public val type: String,
    public val updatedAt: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.relay.outputs.GetNamespaceResult): GetNamespaceResult = GetNamespaceResult(
            createdAt = javaType.createdAt(),
            id = javaType.id(),
            location = javaType.location(),
            metricId = javaType.metricId(),
            name = javaType.name(),
            privateEndpointConnections = javaType.privateEndpointConnections().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.relay.kotlin.outputs.PrivateEndpointConnectionResponse.Companion.toKotlin(args0)
                })
            }),
            provisioningState = javaType.provisioningState(),
            publicNetworkAccess = javaType.publicNetworkAccess().map({ args0 -> args0 }).orElse(null),
            serviceBusEndpoint = javaType.serviceBusEndpoint(),
            sku = javaType.sku().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.relay.kotlin.outputs.SkuResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            status = javaType.status(),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.relay.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
            updatedAt = javaType.updatedAt(),
        )
    }
}
