@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.relay.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * Description of the WCF relay resource.
 * @property createdAt The time the WCF relay was created.
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property isDynamic Returns true if the relay is dynamic; otherwise, false.
 * @property listenerCount The number of listeners for this relay. Note that min :1 and max:25 are supported.
 * @property location The geo-location where the resource lives
 * @property name The name of the resource
 * @property relayType WCF relay type.
 * @property requiresClientAuthorization Returns true if client authorization is needed for this relay; otherwise, false.
 * @property requiresTransportSecurity Returns true if transport security is needed for this relay; otherwise, false.
 * @property systemData The system meta data relating to this resource.
 * @property type The type of the resource. E.g. "Microsoft.EventHub/Namespaces" or "Microsoft.EventHub/Namespaces/EventHubs"
 * @property updatedAt The time the namespace was updated.
 * @property userMetadata The usermetadata is a placeholder to store user-defined string data for the WCF Relay endpoint. For example, it can be used to store descriptive data, such as list of teams and their contact information. Also, user-defined configuration settings can be stored.
 */
public data class GetWCFRelayResult(
    public val createdAt: String,
    public val id: String,
    public val isDynamic: Boolean,
    public val listenerCount: Int,
    public val location: String,
    public val name: String,
    public val relayType: String? = null,
    public val requiresClientAuthorization: Boolean? = null,
    public val requiresTransportSecurity: Boolean? = null,
    public val systemData: SystemDataResponse,
    public val type: String,
    public val updatedAt: String,
    public val userMetadata: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.relay.outputs.GetWCFRelayResult): GetWCFRelayResult = GetWCFRelayResult(
            createdAt = javaType.createdAt(),
            id = javaType.id(),
            isDynamic = javaType.isDynamic(),
            listenerCount = javaType.listenerCount(),
            location = javaType.location(),
            name = javaType.name(),
            relayType = javaType.relayType().map({ args0 -> args0 }).orElse(null),
            requiresClientAuthorization = javaType.requiresClientAuthorization().map({ args0 ->
                args0
            }).orElse(null),
            requiresTransportSecurity = javaType.requiresTransportSecurity().map({ args0 ->
                args0
            }).orElse(null),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.relay.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            type = javaType.type(),
            updatedAt = javaType.updatedAt(),
            userMetadata = javaType.userMetadata().map({ args0 -> args0 }).orElse(null),
        )
    }
}
