@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.relay.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * SKU of the namespace.
 * @property name Name of this SKU.
 * @property tier The tier of this SKU.
 */
public data class SkuResponse(
    public val name: String,
    public val tier: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.relay.outputs.SkuResponse): SkuResponse =
            SkuResponse(
                name = javaType.name(),
                tier = javaType.tier().map({ args0 -> args0 }).orElse(null),
            )
    }
}
