@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.resourceconnector.kotlin

import com.pulumi.azurenative.resourceconnector.ApplianceArgs.builder
import com.pulumi.azurenative.resourceconnector.kotlin.enums.Distro
import com.pulumi.azurenative.resourceconnector.kotlin.inputs.AppliancePropertiesInfrastructureConfigArgs
import com.pulumi.azurenative.resourceconnector.kotlin.inputs.AppliancePropertiesInfrastructureConfigArgsBuilder
import com.pulumi.azurenative.resourceconnector.kotlin.inputs.IdentityArgs
import com.pulumi.azurenative.resourceconnector.kotlin.inputs.IdentityArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Appliances definition.
 * Azure REST API version: 2022-10-27. Prior API version in Azure Native 1.x: 2021-10-31-preview.
 * Other available API versions: 2021-10-31-preview.
 * ## Example Usage
 * ### Create/Update Appliance
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var appliance = new AzureNative.ResourceConnector.Appliance("appliance", new()
 *     {
 *         Distro = AzureNative.ResourceConnector.Distro.AKSEdge,
 *         InfrastructureConfig = new AzureNative.ResourceConnector.Inputs.AppliancePropertiesInfrastructureConfigArgs
 *         {
 *             Provider = AzureNative.ResourceConnector.Provider.VMWare,
 *         },
 *         Location = "West US",
 *         ResourceGroupName = "testresourcegroup",
 *         ResourceName = "appliance01",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/resourceconnector/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := resourceconnector.NewAppliance(ctx, "appliance", &resourceconnector.ApplianceArgs{
 * 			Distro: pulumi.String(resourceconnector.DistroAKSEdge),
 * 			InfrastructureConfig: &resourceconnector.AppliancePropertiesInfrastructureConfigArgs{
 * 				Provider: pulumi.String(resourceconnector.ProviderVMWare),
 * 			},
 * 			Location:          pulumi.String("West US"),
 * 			ResourceGroupName: pulumi.String("testresourcegroup"),
 * 			ResourceName:      pulumi.String("appliance01"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.resourceconnector.Appliance;
 * import com.pulumi.azurenative.resourceconnector.ApplianceArgs;
 * import com.pulumi.azurenative.resourceconnector.inputs.AppliancePropertiesInfrastructureConfigArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var appliance = new Appliance("appliance", ApplianceArgs.builder()
 *             .distro("AKSEdge")
 *             .infrastructureConfig(AppliancePropertiesInfrastructureConfigArgs.builder()
 *                 .provider("VMWare")
 *                 .build())
 *             .location("West US")
 *             .resourceGroupName("testresourcegroup")
 *             .resourceName("appliance01")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:resourceconnector:Appliance appliance01 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ResourceConnector/appliances/{resourceName}
 * ```
 * @property distro Represents a supported Fabric/Infra. (AKSEdge etc...).
 * @property identity Identity for the resource.
 * @property infrastructureConfig Contains infrastructure information about the Appliance
 * @property location The geo-location where the resource lives
 * @property publicKey Certificates pair used to download MSI certificate from HIS. Can only be set once.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property resourceName Appliances name.
 * @property tags Resource tags.
 * @property version Version of the Appliance
 */
public data class ApplianceArgs(
    public val distro: Output<Either<String, Distro>>? = null,
    public val identity: Output<IdentityArgs>? = null,
    public val infrastructureConfig: Output<AppliancePropertiesInfrastructureConfigArgs>? = null,
    public val location: Output<String>? = null,
    public val publicKey: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val resourceName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val version: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.resourceconnector.ApplianceArgs> {
    override fun toJava(): com.pulumi.azurenative.resourceconnector.ApplianceArgs =
        com.pulumi.azurenative.resourceconnector.ApplianceArgs.builder()
            .distro(
                distro?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .identity(identity?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .infrastructureConfig(
                infrastructureConfig?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .location(location?.applyValue({ args0 -> args0 }))
            .publicKey(publicKey?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .resourceName(resourceName?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .version(version?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ApplianceArgs].
 */
@PulumiTagMarker
public class ApplianceArgsBuilder internal constructor() {
    private var distro: Output<Either<String, Distro>>? = null

    private var identity: Output<IdentityArgs>? = null

    private var infrastructureConfig: Output<AppliancePropertiesInfrastructureConfigArgs>? = null

    private var location: Output<String>? = null

    private var publicKey: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var resourceName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var version: Output<String>? = null

    /**
     * @param value Represents a supported Fabric/Infra. (AKSEdge etc...).
     */
    @JvmName("sbtxxraopulxyabs")
    public suspend fun distro(`value`: Output<Either<String, Distro>>) {
        this.distro = value
    }

    /**
     * @param value Identity for the resource.
     */
    @JvmName("oskyokfqjkwgwfve")
    public suspend fun identity(`value`: Output<IdentityArgs>) {
        this.identity = value
    }

    /**
     * @param value Contains infrastructure information about the Appliance
     */
    @JvmName("ijcyxhkasisedipw")
    public suspend fun infrastructureConfig(`value`: Output<AppliancePropertiesInfrastructureConfigArgs>) {
        this.infrastructureConfig = value
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("ewtmqffuummjohwi")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value Certificates pair used to download MSI certificate from HIS. Can only be set once.
     */
    @JvmName("oqxyltjwuwwrfrla")
    public suspend fun publicKey(`value`: Output<String>) {
        this.publicKey = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("sicdstkqlposyuvl")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Appliances name.
     */
    @JvmName("mshfwmytvnxxqcoc")
    public suspend fun resourceName(`value`: Output<String>) {
        this.resourceName = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("admtnyokbimsqbxi")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Version of the Appliance
     */
    @JvmName("wkikqwjqwftjsbjf")
    public suspend fun version(`value`: Output<String>) {
        this.version = value
    }

    /**
     * @param value Represents a supported Fabric/Infra. (AKSEdge etc...).
     */
    @JvmName("sdokaudxgfsuawdx")
    public suspend fun distro(`value`: Either<String, Distro>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.distro = mapped
    }

    /**
     * @param value Represents a supported Fabric/Infra. (AKSEdge etc...).
     */
    @JvmName("ffynbqcityijabwy")
    public fun distro(`value`: String) {
        val toBeMapped = Either.ofLeft<String, Distro>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.distro = mapped
    }

    /**
     * @param value Represents a supported Fabric/Infra. (AKSEdge etc...).
     */
    @JvmName("esvydagwetuvshcq")
    public fun distro(`value`: Distro) {
        val toBeMapped = Either.ofRight<String, Distro>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.distro = mapped
    }

    /**
     * @param value Identity for the resource.
     */
    @JvmName("uoooxwmvhmjtnhoe")
    public suspend fun identity(`value`: IdentityArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.identity = mapped
    }

    /**
     * @param argument Identity for the resource.
     */
    @JvmName("ufbdsrjnimfyqlgv")
    public suspend fun identity(argument: suspend IdentityArgsBuilder.() -> Unit) {
        val toBeMapped = IdentityArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.identity = mapped
    }

    /**
     * @param value Contains infrastructure information about the Appliance
     */
    @JvmName("erxrfustlidfmivp")
    public suspend fun infrastructureConfig(`value`: AppliancePropertiesInfrastructureConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.infrastructureConfig = mapped
    }

    /**
     * @param argument Contains infrastructure information about the Appliance
     */
    @JvmName("bsnsqowyyoylybkw")
    public suspend fun infrastructureConfig(argument: suspend AppliancePropertiesInfrastructureConfigArgsBuilder.() -> Unit) {
        val toBeMapped = AppliancePropertiesInfrastructureConfigArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.infrastructureConfig = mapped
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("ekmamybhbmlhcela")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value Certificates pair used to download MSI certificate from HIS. Can only be set once.
     */
    @JvmName("vjsjhulwcqqydukg")
    public suspend fun publicKey(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.publicKey = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("laavukwfdalganfc")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Appliances name.
     */
    @JvmName("hivypmbqpfdemhls")
    public suspend fun resourceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceName = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("dhwkavwvbhrxwcyb")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("nslwinsrjuyjpteo")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value Version of the Appliance
     */
    @JvmName("afsxvaukfhrokclc")
    public suspend fun version(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.version = mapped
    }

    internal fun build(): ApplianceArgs = ApplianceArgs(
        distro = distro,
        identity = identity,
        infrastructureConfig = infrastructureConfig,
        location = location,
        publicKey = publicKey,
        resourceGroupName = resourceGroupName,
        resourceName = resourceName,
        tags = tags,
        version = version,
    )
}
