@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.resourceconnector.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Information about the connected appliance.
 */
public enum class Provider(
    public val javaValue: com.pulumi.azurenative.resourceconnector.enums.Provider,
) : ConvertibleToJava<com.pulumi.azurenative.resourceconnector.enums.Provider> {
    VMWare(com.pulumi.azurenative.resourceconnector.enums.Provider.VMWare),
    HCI(com.pulumi.azurenative.resourceconnector.enums.Provider.HCI),
    SCVMM(com.pulumi.azurenative.resourceconnector.enums.Provider.SCVMM),
    ;

    override fun toJava(): com.pulumi.azurenative.resourceconnector.enums.Provider = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.resourceconnector.enums.Provider): Provider = Provider.values().first { it.javaValue == javaType }
    }
}
