@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.resourceconnector.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * Appliances definition.
 * @property distro Represents a supported Fabric/Infra. (AKSEdge etc...).
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property identity Identity for the resource.
 * @property infrastructureConfig Contains infrastructure information about the Appliance
 * @property location The geo-location where the resource lives
 * @property name The name of the resource
 * @property provisioningState The current deployment or provisioning state, which only appears in the response.
 * @property publicKey Certificates pair used to download MSI certificate from HIS. Can only be set once.
 * @property status Appliance’s health and state of connection to on-prem
 * @property systemData Azure Resource Manager metadata containing createdBy and modifiedBy information.
 * @property tags Resource tags.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 * @property version Version of the Appliance
 */
public data class GetApplianceResult(
    public val distro: String? = null,
    public val id: String,
    public val identity: IdentityResponse? = null,
    public val infrastructureConfig: AppliancePropertiesResponseInfrastructureConfig? = null,
    public val location: String,
    public val name: String,
    public val provisioningState: String,
    public val publicKey: String? = null,
    public val status: String,
    public val systemData: SystemDataResponse,
    public val tags: Map<String, String>? = null,
    public val type: String,
    public val version: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.resourceconnector.outputs.GetApplianceResult): GetApplianceResult = GetApplianceResult(
            distro = javaType.distro().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            identity = javaType.identity().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.resourceconnector.kotlin.outputs.IdentityResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            infrastructureConfig = javaType.infrastructureConfig().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.resourceconnector.kotlin.outputs.AppliancePropertiesResponseInfrastructureConfig.Companion.toKotlin(args0)
                })
            }).orElse(null),
            location = javaType.location(),
            name = javaType.name(),
            provisioningState = javaType.provisioningState(),
            publicKey = javaType.publicKey().map({ args0 -> args0 }).orElse(null),
            status = javaType.status(),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.resourceconnector.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
            version = javaType.version().map({ args0 -> args0 }).orElse(null),
        )
    }
}
