@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.resourceconnector.kotlin.outputs

import kotlin.Double
import kotlin.String
import kotlin.Suppress

/**
 * Contains the REP (rendezvous endpoint) and “Listener” access token from notification service (NS).
 * @property expirationTime Timestamp when this token will be expired.
 * @property hybridConnectionName Name of the connection
 * @property relay Name of the notification service.
 * @property token Listener access token
 */
public data class HybridConnectionConfigResponse(
    public val expirationTime: Double,
    public val hybridConnectionName: String,
    public val relay: String,
    public val token: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.resourceconnector.outputs.HybridConnectionConfigResponse): HybridConnectionConfigResponse = HybridConnectionConfigResponse(
            expirationTime = javaType.expirationTime(),
            hybridConnectionName = javaType.hybridConnectionName(),
            relay = javaType.relay(),
            token = javaType.token(),
        )
    }
}
