@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.resourceconnector.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * The List Cluster Customer User Credential Results appliance.
 * @property kubeconfigs The list of appliance kubeconfigs.
 * @property sshKeys Map of Customer User Public and Private SSH Keys
 */
public data class ListApplianceClusterCustomerUserCredentialResult(
    public val kubeconfigs: List<ApplianceCredentialKubeconfigResponse>,
    public val sshKeys: Map<String, SSHKeyResponse>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.resourceconnector.outputs.ListApplianceClusterCustomerUserCredentialResult): ListApplianceClusterCustomerUserCredentialResult =
            ListApplianceClusterCustomerUserCredentialResult(
                kubeconfigs = javaType.kubeconfigs().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.resourceconnector.kotlin.outputs.ApplianceCredentialKubeconfigResponse.Companion.toKotlin(args0)
                    })
                }),
                sshKeys = javaType.sshKeys().map({ args0 ->
                    args0.key.to(
                        args0.value.let({ args0 ->
                            com.pulumi.azurenative.resourceconnector.kotlin.outputs.SSHKeyResponse.Companion.toKotlin(args0)
                        }),
                    )
                }).toMap(),
            )
    }
}
