@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.resourceconnector.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * The List Cluster Keys Results appliance.
 * @property artifactProfiles Map of artifacts that contains a list of ArtifactProfile used to upload artifacts such as logs.
 * @property kubeconfigs The list of appliance kubeconfigs.
 * @property sshKeys Map of Customer User Public, Private SSH Keys and Certificate when available.
 */
public data class ListApplianceKeysResult(
    public val artifactProfiles: Map<String, ArtifactProfileResponse>,
    public val kubeconfigs: List<ApplianceCredentialKubeconfigResponse>,
    public val sshKeys: Map<String, SSHKeyResponse>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.resourceconnector.outputs.ListApplianceKeysResult): ListApplianceKeysResult = ListApplianceKeysResult(
            artifactProfiles = javaType.artifactProfiles().map({ args0 ->
                args0.key.to(
                    args0.value.let({ args0 ->
                        com.pulumi.azurenative.resourceconnector.kotlin.outputs.ArtifactProfileResponse.Companion.toKotlin(args0)
                    }),
                )
            }).toMap(),
            kubeconfigs = javaType.kubeconfigs().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.resourceconnector.kotlin.outputs.ApplianceCredentialKubeconfigResponse.Companion.toKotlin(args0)
                })
            }),
            sshKeys = javaType.sshKeys().map({ args0 ->
                args0.key.to(
                    args0.value.let({ args0 ->
                        com.pulumi.azurenative.resourceconnector.kotlin.outputs.SSHKeyResponse.Companion.toKotlin(args0)
                    }),
                )
            }).toMap(),
        )
    }
}
