@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.resourcegraph.kotlin

import com.pulumi.azurenative.resourcegraph.ResourcegraphFunctions.getGraphQueryPlain
import com.pulumi.azurenative.resourcegraph.kotlin.inputs.GetGraphQueryPlainArgs
import com.pulumi.azurenative.resourcegraph.kotlin.inputs.GetGraphQueryPlainArgsBuilder
import com.pulumi.azurenative.resourcegraph.kotlin.outputs.GetGraphQueryResult
import com.pulumi.azurenative.resourcegraph.kotlin.outputs.GetGraphQueryResult.Companion.toKotlin
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

public object ResourcegraphFunctions {
    /**
     * Get a single graph query by its resourceName.
     * Azure REST API version: 2020-04-01-preview.
     * Other available API versions: 2018-09-01-preview.
     * @param argument null
     * @return Graph Query entity definition.
     */
    public suspend fun getGraphQuery(argument: GetGraphQueryPlainArgs): GetGraphQueryResult =
        toKotlin(getGraphQueryPlain(argument.toJava()).await())

    /**
     * @see [getGraphQuery].
     * @param resourceGroupName The name of the resource group.
     * @param resourceName The name of the Graph Query resource.
     * @return Graph Query entity definition.
     */
    public suspend fun getGraphQuery(resourceGroupName: String, resourceName: String): GetGraphQueryResult {
        val argument = GetGraphQueryPlainArgs(
            resourceGroupName = resourceGroupName,
            resourceName = resourceName,
        )
        return toKotlin(getGraphQueryPlain(argument.toJava()).await())
    }

    /**
     * @see [getGraphQuery].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;resourcegraph&#46;kotlin&#46;inputs&#46;GetGraphQueryPlainArgs].
     * @return Graph Query entity definition.
     */
    public suspend fun getGraphQuery(argument: suspend GetGraphQueryPlainArgsBuilder.() -> Unit): GetGraphQueryResult {
        val builder = GetGraphQueryPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return toKotlin(getGraphQueryPlain(builtArgument.toJava()).await())
    }
}
