@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.resourcegraph.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * Graph Query entity definition.
 * @property description The description of a graph query.
 * @property etag This will be used to handle Optimistic Concurrency.
 * @property id Azure resource Id
 * @property location The location of the resource
 * @property name Azure resource name. This is GUID value. The display name should be assigned within properties field.
 * @property query KQL query that will be graph.
 * @property resultKind Enum indicating a type of graph query.
 * @property systemData Metadata pertaining to creation and last modification of the resource.
 * @property tags Resource tags
 * @property timeModified Date and time in UTC of the last modification that was made to this graph query definition.
 * @property type Azure resource type
 */
public data class GetGraphQueryResult(
    public val description: String? = null,
    public val etag: String? = null,
    public val id: String,
    public val location: String,
    public val name: String,
    public val query: String,
    public val resultKind: String,
    public val systemData: SystemDataResponse,
    public val tags: Map<String, String>? = null,
    public val timeModified: String,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.resourcegraph.outputs.GetGraphQueryResult): GetGraphQueryResult = GetGraphQueryResult(
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            etag = javaType.etag().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            location = javaType.location(),
            name = javaType.name(),
            query = javaType.query(),
            resultKind = javaType.resultKind(),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.resourcegraph.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            timeModified = javaType.timeModified(),
            type = javaType.type(),
        )
    }
}
