@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.resourcehealth.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Impacted resource for an event.
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property info Additional information.
 * @property name The name of the resource
 * @property systemData Azure Resource Manager metadata containing createdBy and modifiedBy information.
 * @property targetRegion Impacted resource region name.
 * @property targetResourceId Identity for resource within Microsoft cloud.
 * @property targetResourceType Resource type within Microsoft cloud.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 */
public data class EventImpactedResourceResponse(
    public val id: String,
    public val info: List<KeyValueItemResponse>? = null,
    public val name: String,
    public val systemData: SystemDataResponse,
    public val targetRegion: String,
    public val targetResourceId: String,
    public val targetResourceType: String,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.resourcehealth.outputs.EventImpactedResourceResponse): EventImpactedResourceResponse = EventImpactedResourceResponse(
            id = javaType.id(),
            info = javaType.info().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.resourcehealth.kotlin.outputs.KeyValueItemResponse.Companion.toKotlin(args0)
                })
            }),
            name = javaType.name(),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.resourcehealth.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            targetRegion = javaType.targetRegion(),
            targetResourceId = javaType.targetResourceId(),
            targetResourceType = javaType.targetResourceType(),
            type = javaType.type(),
        )
    }
}
