@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.resources.kotlin

import com.pulumi.azurenative.resources.kotlin.outputs.ContainerConfigurationResponse
import com.pulumi.azurenative.resources.kotlin.outputs.EnvironmentVariableResponse
import com.pulumi.azurenative.resources.kotlin.outputs.ManagedServiceIdentityResponse
import com.pulumi.azurenative.resources.kotlin.outputs.ScriptStatusResponse
import com.pulumi.azurenative.resources.kotlin.outputs.StorageAccountConfigurationResponse
import com.pulumi.azurenative.resources.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Any
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.azurenative.resources.kotlin.outputs.ContainerConfigurationResponse.Companion.toKotlin as containerConfigurationResponseToKotlin
import com.pulumi.azurenative.resources.kotlin.outputs.EnvironmentVariableResponse.Companion.toKotlin as environmentVariableResponseToKotlin
import com.pulumi.azurenative.resources.kotlin.outputs.ManagedServiceIdentityResponse.Companion.toKotlin as managedServiceIdentityResponseToKotlin
import com.pulumi.azurenative.resources.kotlin.outputs.ScriptStatusResponse.Companion.toKotlin as scriptStatusResponseToKotlin
import com.pulumi.azurenative.resources.kotlin.outputs.StorageAccountConfigurationResponse.Companion.toKotlin as storageAccountConfigurationResponseToKotlin
import com.pulumi.azurenative.resources.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [AzureCliScript].
 */
@PulumiTagMarker
public class AzureCliScriptResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: AzureCliScriptArgs = AzureCliScriptArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend AzureCliScriptArgsBuilder.() -> Unit) {
        val builder = AzureCliScriptArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): AzureCliScript {
        val builtJavaResource = com.pulumi.azurenative.resources.AzureCliScript(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return AzureCliScript(builtJavaResource)
    }
}

/**
 * Object model for the Azure CLI script.
 * Azure REST API version: 2020-10-01. Prior API version in Azure Native 1.x: 2020-10-01.
 * ## Example Usage
 * ### DeploymentScriptsCreate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var azureCliScript = new AzureNative.Resources.AzureCliScript("azureCliScript", new()
 *     {
 *         ResourceGroupName = "script-rg",
 *         ScriptName = "MyDeploymentScript",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/resources/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := resources.NewAzureCliScript(ctx, "azureCliScript", &resources.AzureCliScriptArgs{
 * 			ResourceGroupName: pulumi.String("script-rg"),
 * 			ScriptName:        pulumi.String("MyDeploymentScript"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.resources.AzureCliScript;
 * import com.pulumi.azurenative.resources.AzureCliScriptArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var azureCliScript = new AzureCliScript("azureCliScript", AzureCliScriptArgs.builder()
 *             .resourceGroupName("script-rg")
 *             .scriptName("MyDeploymentScript")
 *             .build());
 *     }
 * }
 * ```
 * ### DeploymentScriptsCreateNoUserManagedIdentity
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var azureCliScript = new AzureNative.Resources.AzureCliScript("azureCliScript", new()
 *     {
 *         ResourceGroupName = "script-rg",
 *         ScriptName = "MyDeploymentScript",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/resources/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := resources.NewAzureCliScript(ctx, "azureCliScript", &resources.AzureCliScriptArgs{
 * 			ResourceGroupName: pulumi.String("script-rg"),
 * 			ScriptName:        pulumi.String("MyDeploymentScript"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.resources.AzureCliScript;
 * import com.pulumi.azurenative.resources.AzureCliScriptArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var azureCliScript = new AzureCliScript("azureCliScript", AzureCliScriptArgs.builder()
 *             .resourceGroupName("script-rg")
 *             .scriptName("MyDeploymentScript")
 *             .build());
 *     }
 * }
 * ```
 * ### DeploymentScriptsCreate_MinCreate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var azureCliScript = new AzureNative.Resources.AzureCliScript("azureCliScript", new()
 *     {
 *         ResourceGroupName = "script-rg",
 *         ScriptName = "MyDeploymentScript",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/resources/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := resources.NewAzureCliScript(ctx, "azureCliScript", &resources.AzureCliScriptArgs{
 * 			ResourceGroupName: pulumi.String("script-rg"),
 * 			ScriptName:        pulumi.String("MyDeploymentScript"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.resources.AzureCliScript;
 * import com.pulumi.azurenative.resources.AzureCliScriptArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var azureCliScript = new AzureCliScript("azureCliScript", AzureCliScriptArgs.builder()
 *             .resourceGroupName("script-rg")
 *             .scriptName("MyDeploymentScript")
 *             .build());
 *     }
 * }
 * ```
 * ### DeploymentScriptsCreate_UsingCustomACIName
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var azureCliScript = new AzureNative.Resources.AzureCliScript("azureCliScript", new()
 *     {
 *         ResourceGroupName = "script-rg",
 *         ScriptName = "MyDeploymentScript",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/resources/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := resources.NewAzureCliScript(ctx, "azureCliScript", &resources.AzureCliScriptArgs{
 * 			ResourceGroupName: pulumi.String("script-rg"),
 * 			ScriptName:        pulumi.String("MyDeploymentScript"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.resources.AzureCliScript;
 * import com.pulumi.azurenative.resources.AzureCliScriptArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var azureCliScript = new AzureCliScript("azureCliScript", AzureCliScriptArgs.builder()
 *             .resourceGroupName("script-rg")
 *             .scriptName("MyDeploymentScript")
 *             .build());
 *     }
 * }
 * ```
 * ### DeploymentScriptsCreate_UsingExistingStorageAccount
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var azureCliScript = new AzureNative.Resources.AzureCliScript("azureCliScript", new()
 *     {
 *         ResourceGroupName = "script-rg",
 *         ScriptName = "MyDeploymentScript",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/resources/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := resources.NewAzureCliScript(ctx, "azureCliScript", &resources.AzureCliScriptArgs{
 * 			ResourceGroupName: pulumi.String("script-rg"),
 * 			ScriptName:        pulumi.String("MyDeploymentScript"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.resources.AzureCliScript;
 * import com.pulumi.azurenative.resources.AzureCliScriptArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var azureCliScript = new AzureCliScript("azureCliScript", AzureCliScriptArgs.builder()
 *             .resourceGroupName("script-rg")
 *             .scriptName("MyDeploymentScript")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:resources:AzureCliScript myresource1 /subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.Resources/deploymentScripts/{scriptName}
 * ```
 */
public class AzureCliScript internal constructor(
    override val javaResource: com.pulumi.azurenative.resources.AzureCliScript,
) : KotlinCustomResource(javaResource, AzureCliScriptMapper) {
    /**
     * Command line arguments to pass to the script. Arguments are separated by spaces. ex: -Name blue* -Location 'West US 2'
     */
    public val arguments: Output<String>?
        get() = javaResource.arguments().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Azure CLI module version to be used.
     */
    public val azCliVersion: Output<String>
        get() = javaResource.azCliVersion().applyValue({ args0 -> args0 })

    /**
     * The clean up preference when the script execution gets in a terminal state. Default setting is 'Always'.
     */
    public val cleanupPreference: Output<String>?
        get() = javaResource.cleanupPreference().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Container settings.
     */
    public val containerSettings: Output<ContainerConfigurationResponse>?
        get() = javaResource.containerSettings().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> containerConfigurationResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The environment variables to pass over to the script.
     */
    public val environmentVariables: Output<List<EnvironmentVariableResponse>>?
        get() = javaResource.environmentVariables().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        environmentVariableResponseToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * Gets or sets how the deployment script should be forced to execute even if the script resource has not changed. Can be current time stamp or a GUID.
     */
    public val forceUpdateTag: Output<String>?
        get() = javaResource.forceUpdateTag().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Optional property. Managed identity to be used for this deployment script. Currently, only user-assigned MSI is supported.
     */
    public val identity: Output<ManagedServiceIdentityResponse>?
        get() = javaResource.identity().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    managedServiceIdentityResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Type of the script.
     * Expected value is 'AzureCLI'.
     */
    public val kind: Output<String>
        get() = javaResource.kind().applyValue({ args0 -> args0 })

    /**
     * The location of the ACI and the storage account for the deployment script.
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * Name of this resource.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * List of script outputs.
     */
    public val outputs: Output<Map<String, Any>>
        get() = javaResource.outputs().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * Uri for the script. This is the entry point for the external script.
     */
    public val primaryScriptUri: Output<String>?
        get() = javaResource.primaryScriptUri().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * State of the script execution. This only appears in the response.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Interval for which the service retains the script resource after it reaches a terminal state. Resource will be deleted when this duration expires. Duration is based on ISO 8601 pattern (for example P1D means one day).
     */
    public val retentionInterval: Output<String>
        get() = javaResource.retentionInterval().applyValue({ args0 -> args0 })

    /**
     * Script body.
     */
    public val scriptContent: Output<String>?
        get() = javaResource.scriptContent().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Contains the results of script execution.
     */
    public val status: Output<ScriptStatusResponse>
        get() = javaResource.status().applyValue({ args0 ->
            args0.let({ args0 ->
                scriptStatusResponseToKotlin(args0)
            })
        })

    /**
     * Storage Account settings.
     */
    public val storageAccountSettings: Output<StorageAccountConfigurationResponse>?
        get() = javaResource.storageAccountSettings().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> storageAccountConfigurationResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Supporting files for the external script.
     */
    public val supportingScriptUris: Output<List<String>>?
        get() = javaResource.supportingScriptUris().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    /**
     * The system metadata related to this resource.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Maximum allowed script execution time specified in ISO 8601 format. Default value is P1D
     */
    public val timeout: Output<String>?
        get() = javaResource.timeout().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Type of this resource.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object AzureCliScriptMapper : ResourceMapper<AzureCliScript> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.resources.AzureCliScript::class == javaResource::class

    override fun map(javaResource: Resource): AzureCliScript = AzureCliScript(
        javaResource as
            com.pulumi.azurenative.resources.AzureCliScript,
    )
}

/**
 * @see [AzureCliScript].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [AzureCliScript].
 */
public suspend fun azureCliScript(
    name: String,
    block: suspend AzureCliScriptResourceBuilder.() -> Unit,
): AzureCliScript {
    val builder = AzureCliScriptResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [AzureCliScript].
 * @param name The _unique_ name of the resulting resource.
 */
public fun azureCliScript(name: String): AzureCliScript {
    val builder = AzureCliScriptResourceBuilder()
    builder.name(name)
    return builder.build()
}
