@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.resources.kotlin

import com.pulumi.azurenative.resources.AzureCliScriptArgs.builder
import com.pulumi.azurenative.resources.kotlin.enums.CleanupOptions
import com.pulumi.azurenative.resources.kotlin.inputs.ContainerConfigurationArgs
import com.pulumi.azurenative.resources.kotlin.inputs.ContainerConfigurationArgsBuilder
import com.pulumi.azurenative.resources.kotlin.inputs.EnvironmentVariableArgs
import com.pulumi.azurenative.resources.kotlin.inputs.EnvironmentVariableArgsBuilder
import com.pulumi.azurenative.resources.kotlin.inputs.ManagedServiceIdentityArgs
import com.pulumi.azurenative.resources.kotlin.inputs.ManagedServiceIdentityArgsBuilder
import com.pulumi.azurenative.resources.kotlin.inputs.StorageAccountConfigurationArgs
import com.pulumi.azurenative.resources.kotlin.inputs.StorageAccountConfigurationArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Object model for the Azure CLI script.
 * Azure REST API version: 2020-10-01. Prior API version in Azure Native 1.x: 2020-10-01.
 * ## Example Usage
 * ### DeploymentScriptsCreate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var azureCliScript = new AzureNative.Resources.AzureCliScript("azureCliScript", new()
 *     {
 *         ResourceGroupName = "script-rg",
 *         ScriptName = "MyDeploymentScript",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/resources/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := resources.NewAzureCliScript(ctx, "azureCliScript", &resources.AzureCliScriptArgs{
 * 			ResourceGroupName: pulumi.String("script-rg"),
 * 			ScriptName:        pulumi.String("MyDeploymentScript"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.resources.AzureCliScript;
 * import com.pulumi.azurenative.resources.AzureCliScriptArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var azureCliScript = new AzureCliScript("azureCliScript", AzureCliScriptArgs.builder()
 *             .resourceGroupName("script-rg")
 *             .scriptName("MyDeploymentScript")
 *             .build());
 *     }
 * }
 * ```
 * ### DeploymentScriptsCreateNoUserManagedIdentity
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var azureCliScript = new AzureNative.Resources.AzureCliScript("azureCliScript", new()
 *     {
 *         ResourceGroupName = "script-rg",
 *         ScriptName = "MyDeploymentScript",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/resources/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := resources.NewAzureCliScript(ctx, "azureCliScript", &resources.AzureCliScriptArgs{
 * 			ResourceGroupName: pulumi.String("script-rg"),
 * 			ScriptName:        pulumi.String("MyDeploymentScript"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.resources.AzureCliScript;
 * import com.pulumi.azurenative.resources.AzureCliScriptArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var azureCliScript = new AzureCliScript("azureCliScript", AzureCliScriptArgs.builder()
 *             .resourceGroupName("script-rg")
 *             .scriptName("MyDeploymentScript")
 *             .build());
 *     }
 * }
 * ```
 * ### DeploymentScriptsCreate_MinCreate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var azureCliScript = new AzureNative.Resources.AzureCliScript("azureCliScript", new()
 *     {
 *         ResourceGroupName = "script-rg",
 *         ScriptName = "MyDeploymentScript",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/resources/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := resources.NewAzureCliScript(ctx, "azureCliScript", &resources.AzureCliScriptArgs{
 * 			ResourceGroupName: pulumi.String("script-rg"),
 * 			ScriptName:        pulumi.String("MyDeploymentScript"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.resources.AzureCliScript;
 * import com.pulumi.azurenative.resources.AzureCliScriptArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var azureCliScript = new AzureCliScript("azureCliScript", AzureCliScriptArgs.builder()
 *             .resourceGroupName("script-rg")
 *             .scriptName("MyDeploymentScript")
 *             .build());
 *     }
 * }
 * ```
 * ### DeploymentScriptsCreate_UsingCustomACIName
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var azureCliScript = new AzureNative.Resources.AzureCliScript("azureCliScript", new()
 *     {
 *         ResourceGroupName = "script-rg",
 *         ScriptName = "MyDeploymentScript",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/resources/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := resources.NewAzureCliScript(ctx, "azureCliScript", &resources.AzureCliScriptArgs{
 * 			ResourceGroupName: pulumi.String("script-rg"),
 * 			ScriptName:        pulumi.String("MyDeploymentScript"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.resources.AzureCliScript;
 * import com.pulumi.azurenative.resources.AzureCliScriptArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var azureCliScript = new AzureCliScript("azureCliScript", AzureCliScriptArgs.builder()
 *             .resourceGroupName("script-rg")
 *             .scriptName("MyDeploymentScript")
 *             .build());
 *     }
 * }
 * ```
 * ### DeploymentScriptsCreate_UsingExistingStorageAccount
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var azureCliScript = new AzureNative.Resources.AzureCliScript("azureCliScript", new()
 *     {
 *         ResourceGroupName = "script-rg",
 *         ScriptName = "MyDeploymentScript",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/resources/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := resources.NewAzureCliScript(ctx, "azureCliScript", &resources.AzureCliScriptArgs{
 * 			ResourceGroupName: pulumi.String("script-rg"),
 * 			ScriptName:        pulumi.String("MyDeploymentScript"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.resources.AzureCliScript;
 * import com.pulumi.azurenative.resources.AzureCliScriptArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var azureCliScript = new AzureCliScript("azureCliScript", AzureCliScriptArgs.builder()
 *             .resourceGroupName("script-rg")
 *             .scriptName("MyDeploymentScript")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:resources:AzureCliScript myresource1 /subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.Resources/deploymentScripts/{scriptName}
 * ```
 * @property arguments Command line arguments to pass to the script. Arguments are separated by spaces. ex: -Name blue* -Location 'West US 2'
 * @property azCliVersion Azure CLI module version to be used.
 * @property cleanupPreference The clean up preference when the script execution gets in a terminal state. Default setting is 'Always'.
 * @property containerSettings Container settings.
 * @property environmentVariables The environment variables to pass over to the script.
 * @property forceUpdateTag Gets or sets how the deployment script should be forced to execute even if the script resource has not changed. Can be current time stamp or a GUID.
 * @property identity Optional property. Managed identity to be used for this deployment script. Currently, only user-assigned MSI is supported.
 * @property kind Type of the script.
 * Expected value is 'AzureCLI'.
 * @property location The location of the ACI and the storage account for the deployment script.
 * @property primaryScriptUri Uri for the script. This is the entry point for the external script.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property retentionInterval Interval for which the service retains the script resource after it reaches a terminal state. Resource will be deleted when this duration expires. Duration is based on ISO 8601 pattern (for example P1D means one day).
 * @property scriptContent Script body.
 * @property scriptName Name of the deployment script.
 * @property storageAccountSettings Storage Account settings.
 * @property supportingScriptUris Supporting files for the external script.
 * @property tags Resource tags.
 * @property timeout Maximum allowed script execution time specified in ISO 8601 format. Default value is P1D
 */
public data class AzureCliScriptArgs(
    public val arguments: Output<String>? = null,
    public val azCliVersion: Output<String>? = null,
    public val cleanupPreference: Output<Either<String, CleanupOptions>>? = null,
    public val containerSettings: Output<ContainerConfigurationArgs>? = null,
    public val environmentVariables: Output<List<EnvironmentVariableArgs>>? = null,
    public val forceUpdateTag: Output<String>? = null,
    public val identity: Output<ManagedServiceIdentityArgs>? = null,
    public val kind: Output<String>? = null,
    public val location: Output<String>? = null,
    public val primaryScriptUri: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val retentionInterval: Output<String>? = null,
    public val scriptContent: Output<String>? = null,
    public val scriptName: Output<String>? = null,
    public val storageAccountSettings: Output<StorageAccountConfigurationArgs>? = null,
    public val supportingScriptUris: Output<List<String>>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val timeout: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.resources.AzureCliScriptArgs> {
    override fun toJava(): com.pulumi.azurenative.resources.AzureCliScriptArgs =
        com.pulumi.azurenative.resources.AzureCliScriptArgs.builder()
            .arguments(arguments?.applyValue({ args0 -> args0 }))
            .azCliVersion(azCliVersion?.applyValue({ args0 -> args0 }))
            .cleanupPreference(
                cleanupPreference?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .containerSettings(containerSettings?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .environmentVariables(
                environmentVariables?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .forceUpdateTag(forceUpdateTag?.applyValue({ args0 -> args0 }))
            .identity(identity?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .kind(kind?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .primaryScriptUri(primaryScriptUri?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .retentionInterval(retentionInterval?.applyValue({ args0 -> args0 }))
            .scriptContent(scriptContent?.applyValue({ args0 -> args0 }))
            .scriptName(scriptName?.applyValue({ args0 -> args0 }))
            .storageAccountSettings(
                storageAccountSettings?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .supportingScriptUris(supportingScriptUris?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .timeout(timeout?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AzureCliScriptArgs].
 */
@PulumiTagMarker
public class AzureCliScriptArgsBuilder internal constructor() {
    private var arguments: Output<String>? = null

    private var azCliVersion: Output<String>? = null

    private var cleanupPreference: Output<Either<String, CleanupOptions>>? = null

    private var containerSettings: Output<ContainerConfigurationArgs>? = null

    private var environmentVariables: Output<List<EnvironmentVariableArgs>>? = null

    private var forceUpdateTag: Output<String>? = null

    private var identity: Output<ManagedServiceIdentityArgs>? = null

    private var kind: Output<String>? = null

    private var location: Output<String>? = null

    private var primaryScriptUri: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var retentionInterval: Output<String>? = null

    private var scriptContent: Output<String>? = null

    private var scriptName: Output<String>? = null

    private var storageAccountSettings: Output<StorageAccountConfigurationArgs>? = null

    private var supportingScriptUris: Output<List<String>>? = null

    private var tags: Output<Map<String, String>>? = null

    private var timeout: Output<String>? = null

    /**
     * @param value Command line arguments to pass to the script. Arguments are separated by spaces. ex: -Name blue* -Location 'West US 2'
     */
    @JvmName("ksonatgpcjaheipq")
    public suspend fun arguments(`value`: Output<String>) {
        this.arguments = value
    }

    /**
     * @param value Azure CLI module version to be used.
     */
    @JvmName("kewbqpsbynddgufi")
    public suspend fun azCliVersion(`value`: Output<String>) {
        this.azCliVersion = value
    }

    /**
     * @param value The clean up preference when the script execution gets in a terminal state. Default setting is 'Always'.
     */
    @JvmName("nvlsapkfismannmw")
    public suspend fun cleanupPreference(`value`: Output<Either<String, CleanupOptions>>) {
        this.cleanupPreference = value
    }

    /**
     * @param value Container settings.
     */
    @JvmName("kdflvgeprdkjjkxd")
    public suspend fun containerSettings(`value`: Output<ContainerConfigurationArgs>) {
        this.containerSettings = value
    }

    /**
     * @param value The environment variables to pass over to the script.
     */
    @JvmName("ureocqbvupblgxes")
    public suspend fun environmentVariables(`value`: Output<List<EnvironmentVariableArgs>>) {
        this.environmentVariables = value
    }

    @JvmName("veitsdyvmcpcfwwt")
    public suspend fun environmentVariables(vararg values: Output<EnvironmentVariableArgs>) {
        this.environmentVariables = Output.all(values.asList())
    }

    /**
     * @param values The environment variables to pass over to the script.
     */
    @JvmName("swtveciivjlqkfpn")
    public suspend fun environmentVariables(values: List<Output<EnvironmentVariableArgs>>) {
        this.environmentVariables = Output.all(values)
    }

    /**
     * @param value Gets or sets how the deployment script should be forced to execute even if the script resource has not changed. Can be current time stamp or a GUID.
     */
    @JvmName("qrdesumsqjgivivx")
    public suspend fun forceUpdateTag(`value`: Output<String>) {
        this.forceUpdateTag = value
    }

    /**
     * @param value Optional property. Managed identity to be used for this deployment script. Currently, only user-assigned MSI is supported.
     */
    @JvmName("gfvuqjiqfnqlminf")
    public suspend fun identity(`value`: Output<ManagedServiceIdentityArgs>) {
        this.identity = value
    }

    /**
     * @param value Type of the script.
     * Expected value is 'AzureCLI'.
     */
    @JvmName("wscgdabvfydiqoud")
    public suspend fun kind(`value`: Output<String>) {
        this.kind = value
    }

    /**
     * @param value The location of the ACI and the storage account for the deployment script.
     */
    @JvmName("gfougfmvgnhuuyqm")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value Uri for the script. This is the entry point for the external script.
     */
    @JvmName("lfwsfbtkxkhnexjg")
    public suspend fun primaryScriptUri(`value`: Output<String>) {
        this.primaryScriptUri = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("effvgkncdpfsibii")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Interval for which the service retains the script resource after it reaches a terminal state. Resource will be deleted when this duration expires. Duration is based on ISO 8601 pattern (for example P1D means one day).
     */
    @JvmName("ioofehhmujmkhxcd")
    public suspend fun retentionInterval(`value`: Output<String>) {
        this.retentionInterval = value
    }

    /**
     * @param value Script body.
     */
    @JvmName("wviwvftkafsvkpso")
    public suspend fun scriptContent(`value`: Output<String>) {
        this.scriptContent = value
    }

    /**
     * @param value Name of the deployment script.
     */
    @JvmName("pqhunmhwictaucke")
    public suspend fun scriptName(`value`: Output<String>) {
        this.scriptName = value
    }

    /**
     * @param value Storage Account settings.
     */
    @JvmName("myxxsnhjxaqqtfnc")
    public suspend fun storageAccountSettings(`value`: Output<StorageAccountConfigurationArgs>) {
        this.storageAccountSettings = value
    }

    /**
     * @param value Supporting files for the external script.
     */
    @JvmName("ycvqgtiuscwjvrpa")
    public suspend fun supportingScriptUris(`value`: Output<List<String>>) {
        this.supportingScriptUris = value
    }

    @JvmName("mycpimolgywpbfie")
    public suspend fun supportingScriptUris(vararg values: Output<String>) {
        this.supportingScriptUris = Output.all(values.asList())
    }

    /**
     * @param values Supporting files for the external script.
     */
    @JvmName("rjpypduslfyrklnn")
    public suspend fun supportingScriptUris(values: List<Output<String>>) {
        this.supportingScriptUris = Output.all(values)
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("fykkaovbymshrwqf")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Maximum allowed script execution time specified in ISO 8601 format. Default value is P1D
     */
    @JvmName("xkfvdwmkfnkmxogw")
    public suspend fun timeout(`value`: Output<String>) {
        this.timeout = value
    }

    /**
     * @param value Command line arguments to pass to the script. Arguments are separated by spaces. ex: -Name blue* -Location 'West US 2'
     */
    @JvmName("ogtjeexnrjmrgxqo")
    public suspend fun arguments(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.arguments = mapped
    }

    /**
     * @param value Azure CLI module version to be used.
     */
    @JvmName("npqdwmtwkycbtkke")
    public suspend fun azCliVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.azCliVersion = mapped
    }

    /**
     * @param value The clean up preference when the script execution gets in a terminal state. Default setting is 'Always'.
     */
    @JvmName("suatjkbjwyogpljn")
    public suspend fun cleanupPreference(`value`: Either<String, CleanupOptions>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cleanupPreference = mapped
    }

    /**
     * @param value The clean up preference when the script execution gets in a terminal state. Default setting is 'Always'.
     */
    @JvmName("pnpyfkxacsfswuii")
    public fun cleanupPreference(`value`: String) {
        val toBeMapped = Either.ofLeft<String, CleanupOptions>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.cleanupPreference = mapped
    }

    /**
     * @param value The clean up preference when the script execution gets in a terminal state. Default setting is 'Always'.
     */
    @JvmName("texgewqsufdcfqvx")
    public fun cleanupPreference(`value`: CleanupOptions) {
        val toBeMapped = Either.ofRight<String, CleanupOptions>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.cleanupPreference = mapped
    }

    /**
     * @param value Container settings.
     */
    @JvmName("ujokchmuehhlxsij")
    public suspend fun containerSettings(`value`: ContainerConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.containerSettings = mapped
    }

    /**
     * @param argument Container settings.
     */
    @JvmName("wqctecyjdfnubkoe")
    public suspend fun containerSettings(argument: suspend ContainerConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = ContainerConfigurationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.containerSettings = mapped
    }

    /**
     * @param value The environment variables to pass over to the script.
     */
    @JvmName("ibedaitqghfasgdn")
    public suspend fun environmentVariables(`value`: List<EnvironmentVariableArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.environmentVariables = mapped
    }

    /**
     * @param argument The environment variables to pass over to the script.
     */
    @JvmName("skbbynkfrnanasys")
    public suspend fun environmentVariables(argument: List<suspend EnvironmentVariableArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            EnvironmentVariableArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.environmentVariables = mapped
    }

    /**
     * @param argument The environment variables to pass over to the script.
     */
    @JvmName("ktudulhtokgpdyhw")
    public suspend fun environmentVariables(vararg argument: suspend EnvironmentVariableArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            EnvironmentVariableArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.environmentVariables = mapped
    }

    /**
     * @param argument The environment variables to pass over to the script.
     */
    @JvmName("uewwucsdgrypkxtt")
    public suspend fun environmentVariables(argument: suspend EnvironmentVariableArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(EnvironmentVariableArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.environmentVariables = mapped
    }

    /**
     * @param values The environment variables to pass over to the script.
     */
    @JvmName("jvuxseockxjttafc")
    public suspend fun environmentVariables(vararg values: EnvironmentVariableArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.environmentVariables = mapped
    }

    /**
     * @param value Gets or sets how the deployment script should be forced to execute even if the script resource has not changed. Can be current time stamp or a GUID.
     */
    @JvmName("hglqicifiuopwlka")
    public suspend fun forceUpdateTag(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.forceUpdateTag = mapped
    }

    /**
     * @param value Optional property. Managed identity to be used for this deployment script. Currently, only user-assigned MSI is supported.
     */
    @JvmName("nubsolwwydujvolt")
    public suspend fun identity(`value`: ManagedServiceIdentityArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.identity = mapped
    }

    /**
     * @param argument Optional property. Managed identity to be used for this deployment script. Currently, only user-assigned MSI is supported.
     */
    @JvmName("demukxbhklreumxy")
    public suspend fun identity(argument: suspend ManagedServiceIdentityArgsBuilder.() -> Unit) {
        val toBeMapped = ManagedServiceIdentityArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.identity = mapped
    }

    /**
     * @param value Type of the script.
     * Expected value is 'AzureCLI'.
     */
    @JvmName("ipjipdtlebjivxpj")
    public suspend fun kind(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kind = mapped
    }

    /**
     * @param value The location of the ACI and the storage account for the deployment script.
     */
    @JvmName("lrdroysedwrgttwg")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value Uri for the script. This is the entry point for the external script.
     */
    @JvmName("aotjhtlcjmqkmhxt")
    public suspend fun primaryScriptUri(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.primaryScriptUri = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("queeqgfstkikagtx")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Interval for which the service retains the script resource after it reaches a terminal state. Resource will be deleted when this duration expires. Duration is based on ISO 8601 pattern (for example P1D means one day).
     */
    @JvmName("gkyluqxsltnsgkyi")
    public suspend fun retentionInterval(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.retentionInterval = mapped
    }

    /**
     * @param value Script body.
     */
    @JvmName("pxlhfoaroipoxhtg")
    public suspend fun scriptContent(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scriptContent = mapped
    }

    /**
     * @param value Name of the deployment script.
     */
    @JvmName("spdeuivsmvtouopd")
    public suspend fun scriptName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scriptName = mapped
    }

    /**
     * @param value Storage Account settings.
     */
    @JvmName("vpagcgepkpiskpie")
    public suspend fun storageAccountSettings(`value`: StorageAccountConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storageAccountSettings = mapped
    }

    /**
     * @param argument Storage Account settings.
     */
    @JvmName("hlrynmhjjjrnwjgk")
    public suspend fun storageAccountSettings(argument: suspend StorageAccountConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = StorageAccountConfigurationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.storageAccountSettings = mapped
    }

    /**
     * @param value Supporting files for the external script.
     */
    @JvmName("humcbfgewvpdwukt")
    public suspend fun supportingScriptUris(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.supportingScriptUris = mapped
    }

    /**
     * @param values Supporting files for the external script.
     */
    @JvmName("ctltfcsjvcfaldrq")
    public suspend fun supportingScriptUris(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.supportingScriptUris = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("qjrjhxtlhywjqwfs")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("saitmetgsshnxgwq")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value Maximum allowed script execution time specified in ISO 8601 format. Default value is P1D
     */
    @JvmName("invebqtjbsnwdyvq")
    public suspend fun timeout(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timeout = mapped
    }

    internal fun build(): AzureCliScriptArgs = AzureCliScriptArgs(
        arguments = arguments,
        azCliVersion = azCliVersion,
        cleanupPreference = cleanupPreference,
        containerSettings = containerSettings,
        environmentVariables = environmentVariables,
        forceUpdateTag = forceUpdateTag,
        identity = identity,
        kind = kind,
        location = location,
        primaryScriptUri = primaryScriptUri,
        resourceGroupName = resourceGroupName,
        retentionInterval = retentionInterval,
        scriptContent = scriptContent,
        scriptName = scriptName,
        storageAccountSettings = storageAccountSettings,
        supportingScriptUris = supportingScriptUris,
        tags = tags,
        timeout = timeout,
    )
}
