@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.resources.kotlin

import com.pulumi.azurenative.resources.kotlin.outputs.DeploymentPropertiesExtendedResponse
import com.pulumi.azurenative.resources.kotlin.outputs.DeploymentPropertiesExtendedResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [DeploymentAtScope].
 */
@PulumiTagMarker
public class DeploymentAtScopeResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: DeploymentAtScopeArgs = DeploymentAtScopeArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend DeploymentAtScopeArgsBuilder.() -> Unit) {
        val builder = DeploymentAtScopeArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): DeploymentAtScope {
        val builtJavaResource =
            com.pulumi.azurenative.resources.DeploymentAtScope(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return DeploymentAtScope(builtJavaResource)
    }
}

/**
 * Deployment information.
 * Azure REST API version: 2022-09-01. Prior API version in Azure Native 1.x: 2021-01-01.
 * Other available API versions: 2023-07-01, 2024-03-01.
 * ## Example Usage
 * ### Create deployment at a given scope.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var deploymentAtScope = new AzureNative.Resources.DeploymentAtScope("deploymentAtScope", new()
 *     {
 *         DeploymentName = "my-deployment",
 *         Location = "eastus",
 *         Properties = new AzureNative.Resources.Inputs.DeploymentPropertiesArgs
 *         {
 *             Mode = AzureNative.Resources.DeploymentMode.Incremental,
 *             Parameters = null,
 *             TemplateLink = new AzureNative.Resources.Inputs.TemplateLinkArgs
 *             {
 *                 Uri = "https://example.com/exampleTemplate.json",
 *             },
 *         },
 *         Scope = "providers/Microsoft.Management/managementGroups/my-management-group-id",
 *         Tags =
 *         {
 *             { "tagKey1", "tag-value-1" },
 *             { "tagKey2", "tag-value-2" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/resources/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := resources.NewDeploymentAtScope(ctx, "deploymentAtScope", &resources.DeploymentAtScopeArgs{
 * 			DeploymentName: pulumi.String("my-deployment"),
 * 			Location:       pulumi.String("eastus"),
 * 			Properties: &resources.DeploymentPropertiesArgs{
 * 				Mode:       resources.DeploymentModeIncremental,
 * 				Parameters: nil,
 * 				TemplateLink: &resources.TemplateLinkArgs{
 * 					Uri: pulumi.String("https://example.com/exampleTemplate.json"),
 * 				},
 * 			},
 * 			Scope: pulumi.String("providers/Microsoft.Management/managementGroups/my-management-group-id"),
 * 			Tags: pulumi.StringMap{
 * 				"tagKey1": pulumi.String("tag-value-1"),
 * 				"tagKey2": pulumi.String("tag-value-2"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.resources.DeploymentAtScope;
 * import com.pulumi.azurenative.resources.DeploymentAtScopeArgs;
 * import com.pulumi.azurenative.resources.inputs.DeploymentPropertiesArgs;
 * import com.pulumi.azurenative.resources.inputs.TemplateLinkArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var deploymentAtScope = new DeploymentAtScope("deploymentAtScope", DeploymentAtScopeArgs.builder()
 *             .deploymentName("my-deployment")
 *             .location("eastus")
 *             .properties(DeploymentPropertiesArgs.builder()
 *                 .mode("Incremental")
 *                 .parameters()
 *                 .templateLink(TemplateLinkArgs.builder()
 *                     .uri("https://example.com/exampleTemplate.json")
 *                     .build())
 *                 .build())
 *             .scope("providers/Microsoft.Management/managementGroups/my-management-group-id")
 *             .tags(Map.ofEntries(
 *                 Map.entry("tagKey1", "tag-value-1"),
 *                 Map.entry("tagKey2", "tag-value-2")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:resources:DeploymentAtScope my-deployment /{scope}/providers/Microsoft.Resources/deployments/{deploymentName}
 * ```
 */
public class DeploymentAtScope internal constructor(
    override val javaResource: com.pulumi.azurenative.resources.DeploymentAtScope,
) : KotlinCustomResource(javaResource, DeploymentAtScopeMapper) {
    /**
     * the location of the deployment.
     */
    public val location: Output<String>?
        get() = javaResource.location().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The name of the deployment.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Deployment properties.
     */
    public val properties: Output<DeploymentPropertiesExtendedResponse>
        get() = javaResource.properties().applyValue({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })

    /**
     * Deployment tags
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The type of the deployment.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object DeploymentAtScopeMapper : ResourceMapper<DeploymentAtScope> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.resources.DeploymentAtScope::class == javaResource::class

    override fun map(javaResource: Resource): DeploymentAtScope = DeploymentAtScope(
        javaResource as
            com.pulumi.azurenative.resources.DeploymentAtScope,
    )
}

/**
 * @see [DeploymentAtScope].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [DeploymentAtScope].
 */
public suspend fun deploymentAtScope(
    name: String,
    block: suspend DeploymentAtScopeResourceBuilder.() -> Unit,
): DeploymentAtScope {
    val builder = DeploymentAtScopeResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [DeploymentAtScope].
 * @param name The _unique_ name of the resulting resource.
 */
public fun deploymentAtScope(name: String): DeploymentAtScope {
    val builder = DeploymentAtScopeResourceBuilder()
    builder.name(name)
    return builder.build()
}
