@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.resources.kotlin

import com.pulumi.azurenative.resources.kotlin.outputs.ResourceGroupPropertiesResponse
import com.pulumi.azurenative.resources.kotlin.outputs.ResourceGroupPropertiesResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [ResourceGroup].
 */
@PulumiTagMarker
public class ResourceGroupResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ResourceGroupArgs = ResourceGroupArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ResourceGroupArgsBuilder.() -> Unit) {
        val builder = ResourceGroupArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ResourceGroup {
        val builtJavaResource = com.pulumi.azurenative.resources.ResourceGroup(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return ResourceGroup(builtJavaResource)
    }
}

/**
 * Resource group information.
 * Azure REST API version: 2022-09-01. Prior API version in Azure Native 1.x: 2019-05-01.
 * Other available API versions: 2018-02-01, 2023-07-01, 2024-03-01.
 * ## Example Usage
 * ### Create or update a resource group
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var resourceGroup = new AzureNative.Resources.ResourceGroup("resourceGroup", new()
 *     {
 *         Location = "eastus",
 *         ResourceGroupName = "my-resource-group",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/resources/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := resources.NewResourceGroup(ctx, "resourceGroup", &resources.ResourceGroupArgs{
 * 			Location:          pulumi.String("eastus"),
 * 			ResourceGroupName: pulumi.String("my-resource-group"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.resources.ResourceGroup;
 * import com.pulumi.azurenative.resources.ResourceGroupArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var resourceGroup = new ResourceGroup("resourceGroup", ResourceGroupArgs.builder()
 *             .location("eastus")
 *             .resourceGroupName("my-resource-group")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:resources:ResourceGroup my-resource-group /subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}
 * ```
 */
public class ResourceGroup internal constructor(
    override val javaResource: com.pulumi.azurenative.resources.ResourceGroup,
) : KotlinCustomResource(javaResource, ResourceGroupMapper) {
    /**
     * The location of the resource group. It cannot be changed after the resource group has been created. It must be one of the supported Azure locations.
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * The ID of the resource that manages this resource group.
     */
    public val managedBy: Output<String>?
        get() = javaResource.managedBy().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The name of the resource group.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The resource group properties.
     */
    public val properties: Output<ResourceGroupPropertiesResponse>
        get() = javaResource.properties().applyValue({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })

    /**
     * The tags attached to the resource group.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The type of the resource group.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object ResourceGroupMapper : ResourceMapper<ResourceGroup> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.resources.ResourceGroup::class == javaResource::class

    override fun map(javaResource: Resource): ResourceGroup = ResourceGroup(
        javaResource as
            com.pulumi.azurenative.resources.ResourceGroup,
    )
}

/**
 * @see [ResourceGroup].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ResourceGroup].
 */
public suspend fun resourceGroup(
    name: String,
    block: suspend ResourceGroupResourceBuilder.() -> Unit,
): ResourceGroup {
    val builder = ResourceGroupResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ResourceGroup].
 * @param name The _unique_ name of the resulting resource.
 */
public fun resourceGroup(name: String): ResourceGroup {
    val builder = ResourceGroupResourceBuilder()
    builder.name(name)
    return builder.build()
}
