@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.resources.kotlin

import com.pulumi.azurenative.resources.TagAtScopeArgs.builder
import com.pulumi.azurenative.resources.kotlin.inputs.TagsArgs
import com.pulumi.azurenative.resources.kotlin.inputs.TagsArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Wrapper resource for tags API requests and responses.
 * Azure REST API version: 2022-09-01. Prior API version in Azure Native 1.x: 2019-10-01.
 * Other available API versions: 2023-07-01, 2024-03-01.
 * ## Example Usage
 * ### Update tags on a resource
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var tagAtScope = new AzureNative.Resources.TagAtScope("tagAtScope", new()
 *     {
 *         Properties = new AzureNative.Resources.Inputs.TagsArgs
 *         {
 *             Tags =
 *             {
 *                 { "tagKey1", "tag-value-1" },
 *                 { "tagKey2", "tag-value-2" },
 *             },
 *         },
 *         Scope = "subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/my-resource-group/providers/myPRNameSpace/VM/myVm",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/resources/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := resources.NewTagAtScope(ctx, "tagAtScope", &resources.TagAtScopeArgs{
 * 			Properties: &resources.TagsArgs{
 * 				Tags: pulumi.StringMap{
 * 					"tagKey1": pulumi.String("tag-value-1"),
 * 					"tagKey2": pulumi.String("tag-value-2"),
 * 				},
 * 			},
 * 			Scope: pulumi.String("subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/my-resource-group/providers/myPRNameSpace/VM/myVm"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.resources.TagAtScope;
 * import com.pulumi.azurenative.resources.TagAtScopeArgs;
 * import com.pulumi.azurenative.resources.inputs.TagsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var tagAtScope = new TagAtScope("tagAtScope", TagAtScopeArgs.builder()
 *             .properties(TagsArgs.builder()
 *                 .tags(Map.ofEntries(
 *                     Map.entry("tagKey1", "tag-value-1"),
 *                     Map.entry("tagKey2", "tag-value-2")
 *                 ))
 *                 .build())
 *             .scope("subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/my-resource-group/providers/myPRNameSpace/VM/myVm")
 *             .build());
 *     }
 * }
 * ```
 * ### Update tags on a subscription
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var tagAtScope = new AzureNative.Resources.TagAtScope("tagAtScope", new()
 *     {
 *         Properties = new AzureNative.Resources.Inputs.TagsArgs
 *         {
 *             Tags =
 *             {
 *                 { "tagKey1", "tag-value-1" },
 *                 { "tagKey2", "tag-value-2" },
 *             },
 *         },
 *         Scope = "subscriptions/00000000-0000-0000-0000-000000000000",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/resources/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := resources.NewTagAtScope(ctx, "tagAtScope", &resources.TagAtScopeArgs{
 * 			Properties: &resources.TagsArgs{
 * 				Tags: pulumi.StringMap{
 * 					"tagKey1": pulumi.String("tag-value-1"),
 * 					"tagKey2": pulumi.String("tag-value-2"),
 * 				},
 * 			},
 * 			Scope: pulumi.String("subscriptions/00000000-0000-0000-0000-000000000000"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.resources.TagAtScope;
 * import com.pulumi.azurenative.resources.TagAtScopeArgs;
 * import com.pulumi.azurenative.resources.inputs.TagsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var tagAtScope = new TagAtScope("tagAtScope", TagAtScopeArgs.builder()
 *             .properties(TagsArgs.builder()
 *                 .tags(Map.ofEntries(
 *                     Map.entry("tagKey1", "tag-value-1"),
 *                     Map.entry("tagKey2", "tag-value-2")
 *                 ))
 *                 .build())
 *             .scope("subscriptions/00000000-0000-0000-0000-000000000000")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:resources:TagAtScope myresource1 /{scope}/providers/Microsoft.Resources/tags/default
 * ```
 * @property properties The set of tags.
 * @property scope The resource scope.
 */
public data class TagAtScopeArgs(
    public val properties: Output<TagsArgs>? = null,
    public val scope: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.resources.TagAtScopeArgs> {
    override fun toJava(): com.pulumi.azurenative.resources.TagAtScopeArgs =
        com.pulumi.azurenative.resources.TagAtScopeArgs.builder()
            .properties(properties?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .scope(scope?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [TagAtScopeArgs].
 */
@PulumiTagMarker
public class TagAtScopeArgsBuilder internal constructor() {
    private var properties: Output<TagsArgs>? = null

    private var scope: Output<String>? = null

    /**
     * @param value The set of tags.
     */
    @JvmName("elyygfyotobvuscn")
    public suspend fun properties(`value`: Output<TagsArgs>) {
        this.properties = value
    }

    /**
     * @param value The resource scope.
     */
    @JvmName("voceyltmeufwucnf")
    public suspend fun scope(`value`: Output<String>) {
        this.scope = value
    }

    /**
     * @param value The set of tags.
     */
    @JvmName("kwhproijrgeyuxrb")
    public suspend fun properties(`value`: TagsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param argument The set of tags.
     */
    @JvmName("gbaylixgkvbxvkmp")
    public suspend fun properties(argument: suspend TagsArgsBuilder.() -> Unit) {
        val toBeMapped = TagsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.properties = mapped
    }

    /**
     * @param value The resource scope.
     */
    @JvmName("vmseenxkvnksfkiv")
    public suspend fun scope(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scope = mapped
    }

    internal fun build(): TagAtScopeArgs = TagAtScopeArgs(
        properties = properties,
        scope = scope,
    )
}
