@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.resources.kotlin

import com.pulumi.azurenative.resources.TemplateSpecVersionArgs.builder
import com.pulumi.azurenative.resources.kotlin.inputs.LinkedTemplateArtifactArgs
import com.pulumi.azurenative.resources.kotlin.inputs.LinkedTemplateArtifactArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Any
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Template Spec Version object.
 * Azure REST API version: 2022-02-01. Prior API version in Azure Native 1.x: 2022-02-01.
 * Other available API versions: 2019-06-01-preview.
 * ## Example Usage
 * ### TemplateSpecVersionsCreateUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var templateSpecVersion = new AzureNative.Resources.TemplateSpecVersion("templateSpecVersion", new()
 *     {
 *         Description = "This is version v1.0 of our template content",
 *         Location = "eastus",
 *         MainTemplate = new Dictionary<string, object?>
 *         {
 *             ["$schema"] = "http://schema.management.azure.com/schemas/2015-01-01/deploymentTemplate.json#",
 *             ["contentVersion"] = "1.0.0.0",
 *             ["parameters"] = new Dictionary<string, object?>
 *             {
 *             },
 *             ["resources"] = new[]
 *             {
 *             },
 *         },
 *         ResourceGroupName = "templateSpecRG",
 *         TemplateSpecName = "simpleTemplateSpec",
 *         TemplateSpecVersion = "v1.0",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/resources/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := resources.NewTemplateSpecVersion(ctx, "templateSpecVersion", &resources.TemplateSpecVersionArgs{
 * 			Description: pulumi.String("This is version v1.0 of our template content"),
 * 			Location:    pulumi.String("eastus"),
 * 			MainTemplate: pulumi.Any(map[string]interface{}{
 * 				"$schema":        "http://schema.management.azure.com/schemas/2015-01-01/deploymentTemplate.json#",
 * 				"contentVersion": "1.0.0.0",
 * 				"parameters":     nil,
 * 				"resources":      []interface{}{},
 * 			}),
 * 			ResourceGroupName:   pulumi.String("templateSpecRG"),
 * 			TemplateSpecName:    pulumi.String("simpleTemplateSpec"),
 * 			TemplateSpecVersion: pulumi.String("v1.0"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.resources.TemplateSpecVersion;
 * import com.pulumi.azurenative.resources.TemplateSpecVersionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var templateSpecVersion = new TemplateSpecVersion("templateSpecVersion", TemplateSpecVersionArgs.builder()
 *             .description("This is version v1.0 of our template content")
 *             .location("eastus")
 *             .mainTemplate(Map.ofEntries(
 *                 Map.entry("$schema", "http://schema.management.azure.com/schemas/2015-01-01/deploymentTemplate.json#"),
 *                 Map.entry("contentVersion", "1.0.0.0"),
 *                 Map.entry("parameters", ),
 *                 Map.entry("resources", )
 *             ))
 *             .resourceGroupName("templateSpecRG")
 *             .templateSpecName("simpleTemplateSpec")
 *             .templateSpecVersion("v1.0")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:resources:TemplateSpecVersion v1.0 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Resources/templateSpecs/{templateSpecName}/versions/{templateSpecVersion}
 * ```
 * @property description Template Spec version description.
 * @property linkedTemplates An array of linked template artifacts.
 * @property location The location of the Template Spec Version. It must match the location of the parent Template Spec.
 * @property mainTemplate The main Azure Resource Manager template content.
 * @property metadata The version metadata. Metadata is an open-ended object and is typically a collection of key-value pairs.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property tags Resource tags.
 * @property templateSpecName Name of the Template Spec.
 * @property templateSpecVersion The version of the Template Spec.
 * @property uiFormDefinition The Azure Resource Manager template UI definition content.
 */
public data class TemplateSpecVersionArgs(
    public val description: Output<String>? = null,
    public val linkedTemplates: Output<List<LinkedTemplateArtifactArgs>>? = null,
    public val location: Output<String>? = null,
    public val mainTemplate: Output<Any>? = null,
    public val metadata: Output<Any>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val templateSpecName: Output<String>? = null,
    public val templateSpecVersion: Output<String>? = null,
    public val uiFormDefinition: Output<Any>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.resources.TemplateSpecVersionArgs> {
    override fun toJava(): com.pulumi.azurenative.resources.TemplateSpecVersionArgs =
        com.pulumi.azurenative.resources.TemplateSpecVersionArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .linkedTemplates(
                linkedTemplates?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .location(location?.applyValue({ args0 -> args0 }))
            .mainTemplate(mainTemplate?.applyValue({ args0 -> args0 }))
            .metadata(metadata?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .templateSpecName(templateSpecName?.applyValue({ args0 -> args0 }))
            .templateSpecVersion(templateSpecVersion?.applyValue({ args0 -> args0 }))
            .uiFormDefinition(uiFormDefinition?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [TemplateSpecVersionArgs].
 */
@PulumiTagMarker
public class TemplateSpecVersionArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var linkedTemplates: Output<List<LinkedTemplateArtifactArgs>>? = null

    private var location: Output<String>? = null

    private var mainTemplate: Output<Any>? = null

    private var metadata: Output<Any>? = null

    private var resourceGroupName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var templateSpecName: Output<String>? = null

    private var templateSpecVersion: Output<String>? = null

    private var uiFormDefinition: Output<Any>? = null

    /**
     * @param value Template Spec version description.
     */
    @JvmName("eapfcnqjshdvutpw")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value An array of linked template artifacts.
     */
    @JvmName("guooqmkippgudlns")
    public suspend fun linkedTemplates(`value`: Output<List<LinkedTemplateArtifactArgs>>) {
        this.linkedTemplates = value
    }

    @JvmName("wumlgxawjlfaxims")
    public suspend fun linkedTemplates(vararg values: Output<LinkedTemplateArtifactArgs>) {
        this.linkedTemplates = Output.all(values.asList())
    }

    /**
     * @param values An array of linked template artifacts.
     */
    @JvmName("nchodxnvfdoouqwh")
    public suspend fun linkedTemplates(values: List<Output<LinkedTemplateArtifactArgs>>) {
        this.linkedTemplates = Output.all(values)
    }

    /**
     * @param value The location of the Template Spec Version. It must match the location of the parent Template Spec.
     */
    @JvmName("bqhrmdbraerepfju")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The main Azure Resource Manager template content.
     */
    @JvmName("gjlxwqtnwqiagkph")
    public suspend fun mainTemplate(`value`: Output<Any>) {
        this.mainTemplate = value
    }

    /**
     * @param value The version metadata. Metadata is an open-ended object and is typically a collection of key-value pairs.
     */
    @JvmName("ggbwjciwojdlhrbb")
    public suspend fun metadata(`value`: Output<Any>) {
        this.metadata = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("jhcyjgwcnlpuccrk")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("efglnrfunkgwdykm")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Name of the Template Spec.
     */
    @JvmName("vlqpwnqkkmmhxjjg")
    public suspend fun templateSpecName(`value`: Output<String>) {
        this.templateSpecName = value
    }

    /**
     * @param value The version of the Template Spec.
     */
    @JvmName("nscqfxhojjulwchf")
    public suspend fun templateSpecVersion(`value`: Output<String>) {
        this.templateSpecVersion = value
    }

    /**
     * @param value The Azure Resource Manager template UI definition content.
     */
    @JvmName("gsitwlarpdeskwlr")
    public suspend fun uiFormDefinition(`value`: Output<Any>) {
        this.uiFormDefinition = value
    }

    /**
     * @param value Template Spec version description.
     */
    @JvmName("yswjnodwnfxelvkn")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value An array of linked template artifacts.
     */
    @JvmName("vaymwydqrbbbipqi")
    public suspend fun linkedTemplates(`value`: List<LinkedTemplateArtifactArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.linkedTemplates = mapped
    }

    /**
     * @param argument An array of linked template artifacts.
     */
    @JvmName("drcatgopywmrauvy")
    public suspend fun linkedTemplates(argument: List<suspend LinkedTemplateArtifactArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            LinkedTemplateArtifactArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.linkedTemplates = mapped
    }

    /**
     * @param argument An array of linked template artifacts.
     */
    @JvmName("fkkyopybqbkrpbtm")
    public suspend fun linkedTemplates(vararg argument: suspend LinkedTemplateArtifactArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            LinkedTemplateArtifactArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.linkedTemplates = mapped
    }

    /**
     * @param argument An array of linked template artifacts.
     */
    @JvmName("jgwwlquroegklutf")
    public suspend fun linkedTemplates(argument: suspend LinkedTemplateArtifactArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(LinkedTemplateArtifactArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.linkedTemplates = mapped
    }

    /**
     * @param values An array of linked template artifacts.
     */
    @JvmName("rsbrmxgebyigcbpt")
    public suspend fun linkedTemplates(vararg values: LinkedTemplateArtifactArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.linkedTemplates = mapped
    }

    /**
     * @param value The location of the Template Spec Version. It must match the location of the parent Template Spec.
     */
    @JvmName("wcpdhxmnjtywiesk")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The main Azure Resource Manager template content.
     */
    @JvmName("pgntfnltdvrhbjca")
    public suspend fun mainTemplate(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.mainTemplate = mapped
    }

    /**
     * @param value The version metadata. Metadata is an open-ended object and is typically a collection of key-value pairs.
     */
    @JvmName("ajfubpcnukhqlheb")
    public suspend fun metadata(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.metadata = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("bentiphwgfbknqjb")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("aqusfacnrrnplxss")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("fvtrghtlsowsqpur")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value Name of the Template Spec.
     */
    @JvmName("oglvpajxxqtnkaus")
    public suspend fun templateSpecName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.templateSpecName = mapped
    }

    /**
     * @param value The version of the Template Spec.
     */
    @JvmName("tfknfgdkhfiuvjxa")
    public suspend fun templateSpecVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.templateSpecVersion = mapped
    }

    /**
     * @param value The Azure Resource Manager template UI definition content.
     */
    @JvmName("bvcxgyslodljpgry")
    public suspend fun uiFormDefinition(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.uiFormDefinition = mapped
    }

    internal fun build(): TemplateSpecVersionArgs = TemplateSpecVersionArgs(
        description = description,
        linkedTemplates = linkedTemplates,
        location = location,
        mainTemplate = mainTemplate,
        metadata = metadata,
        resourceGroupName = resourceGroupName,
        tags = tags,
        templateSpecName = templateSpecName,
        templateSpecVersion = templateSpecVersion,
        uiFormDefinition = uiFormDefinition,
    )
}
