@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.resources.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The clean up preference when the script execution gets in a terminal state. Default setting is 'Always'.
 */
public enum class CleanupOptions(
    public val javaValue: com.pulumi.azurenative.resources.enums.CleanupOptions,
) : ConvertibleToJava<com.pulumi.azurenative.resources.enums.CleanupOptions> {
    Always(com.pulumi.azurenative.resources.enums.CleanupOptions.Always),
    OnSuccess(com.pulumi.azurenative.resources.enums.CleanupOptions.OnSuccess),
    OnExpiration(com.pulumi.azurenative.resources.enums.CleanupOptions.OnExpiration),
    ;

    override fun toJava(): com.pulumi.azurenative.resources.enums.CleanupOptions = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.resources.enums.CleanupOptions): CleanupOptions = CleanupOptions.values().first { it.javaValue == javaType }
    }
}
