@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.resources.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Specifies the action that should be taken on the resource when the deployment stack is deleted. Delete will attempt to delete the resource from Azure. Detach will leave the resource in it's current state.
 */
public enum class DeploymentStacksDeleteDetachEnum(
    public val javaValue: com.pulumi.azurenative.resources.enums.DeploymentStacksDeleteDetachEnum,
) : ConvertibleToJava<com.pulumi.azurenative.resources.enums.DeploymentStacksDeleteDetachEnum> {
    Delete(com.pulumi.azurenative.resources.enums.DeploymentStacksDeleteDetachEnum.Delete),
    Detach(com.pulumi.azurenative.resources.enums.DeploymentStacksDeleteDetachEnum.Detach),
    ;

    override fun toJava(): com.pulumi.azurenative.resources.enums.DeploymentStacksDeleteDetachEnum =
        javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.resources.enums.DeploymentStacksDeleteDetachEnum): DeploymentStacksDeleteDetachEnum =
            DeploymentStacksDeleteDetachEnum.values().first { it.javaValue == javaType }
    }
}
