@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.resources.kotlin.inputs

import com.pulumi.azurenative.resources.inputs.ParametersLinkArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Entity representing the reference to the deployment parameters.
 * @property contentVersion If included, must match the ContentVersion in the template.
 * @property uri The URI of the parameters file.
 */
public data class ParametersLinkArgs(
    public val contentVersion: Output<String>? = null,
    public val uri: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.resources.inputs.ParametersLinkArgs> {
    override fun toJava(): com.pulumi.azurenative.resources.inputs.ParametersLinkArgs =
        com.pulumi.azurenative.resources.inputs.ParametersLinkArgs.builder()
            .contentVersion(contentVersion?.applyValue({ args0 -> args0 }))
            .uri(uri.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ParametersLinkArgs].
 */
@PulumiTagMarker
public class ParametersLinkArgsBuilder internal constructor() {
    private var contentVersion: Output<String>? = null

    private var uri: Output<String>? = null

    /**
     * @param value If included, must match the ContentVersion in the template.
     */
    @JvmName("klrqsvufouruvprl")
    public suspend fun contentVersion(`value`: Output<String>) {
        this.contentVersion = value
    }

    /**
     * @param value The URI of the parameters file.
     */
    @JvmName("vinnxkbxvewhghyh")
    public suspend fun uri(`value`: Output<String>) {
        this.uri = value
    }

    /**
     * @param value If included, must match the ContentVersion in the template.
     */
    @JvmName("vtendkcgyxkpeusw")
    public suspend fun contentVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.contentVersion = mapped
    }

    /**
     * @param value The URI of the parameters file.
     */
    @JvmName("ukhfdhycybbmhynp")
    public suspend fun uri(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.uri = mapped
    }

    internal fun build(): ParametersLinkArgs = ParametersLinkArgs(
        contentVersion = contentVersion,
        uri = uri ?: throw PulumiNullFieldException("uri"),
    )
}
