@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.resources.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property attributes The attributes of the token that the alias path is referring to.
 * @property type The type of the token that the alias path is referring to.
 */
public data class AliasPathMetadataResponse(
    public val attributes: String,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.resources.outputs.AliasPathMetadataResponse): AliasPathMetadataResponse = AliasPathMetadataResponse(
            attributes = javaType.attributes(),
            type = javaType.type(),
        )
    }
}
