@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.resources.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * The type of the paths for alias.
 * @property apiVersions The API versions.
 * @property metadata The metadata of the alias path. If missing, fall back to the default metadata of the alias.
 * @property path The path of an alias.
 * @property pattern The pattern for an alias path.
 */
public data class AliasPathResponse(
    public val apiVersions: List<String>? = null,
    public val metadata: AliasPathMetadataResponse,
    public val path: String? = null,
    public val pattern: AliasPatternResponse? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.resources.outputs.AliasPathResponse): AliasPathResponse = AliasPathResponse(
            apiVersions = javaType.apiVersions().map({ args0 -> args0 }),
            metadata = javaType.metadata().let({ args0 ->
                com.pulumi.azurenative.resources.kotlin.outputs.AliasPathMetadataResponse.Companion.toKotlin(args0)
            }),
            path = javaType.path().map({ args0 -> args0 }).orElse(null),
            pattern = javaType.pattern().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.resources.kotlin.outputs.AliasPatternResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
