@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.resources.kotlin.outputs

import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Deployment properties with additional details.
 * @property correlationId The correlation ID of the deployment.
 * @property debugSetting The debug setting of the deployment.
 * @property dependencies The list of deployment dependencies.
 * @property duration The duration of the template deployment.
 * @property error The deployment error.
 * @property mode The deployment mode. Possible values are Incremental and Complete.
 * @property onErrorDeployment The deployment on error behavior.
 * @property outputResources Array of provisioned resources.
 * @property outputs Key/value pairs that represent deployment output.
 * @property parameters Deployment parameters.
 * @property parametersLink The URI referencing the parameters.
 * @property providers The list of resource providers needed for the deployment.
 * @property provisioningState Denotes the state of provisioning.
 * @property templateHash The hash produced for the template.
 * @property templateLink The URI referencing the template.
 * @property timestamp The timestamp of the template deployment.
 * @property validatedResources Array of validated resources.
 */
public data class DeploymentPropertiesExtendedResponse(
    public val correlationId: String,
    public val debugSetting: DebugSettingResponse,
    public val dependencies: List<DependencyResponse>,
    public val duration: String,
    public val error: ErrorResponseResponse,
    public val mode: String,
    public val onErrorDeployment: OnErrorDeploymentExtendedResponse,
    public val outputResources: List<ResourceReferenceResponse>,
    public val outputs: Any,
    public val parameters: Any,
    public val parametersLink: ParametersLinkResponse,
    public val providers: List<ProviderResponse>,
    public val provisioningState: String,
    public val templateHash: String,
    public val templateLink: TemplateLinkResponse,
    public val timestamp: String,
    public val validatedResources: List<ResourceReferenceResponse>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.resources.outputs.DeploymentPropertiesExtendedResponse): DeploymentPropertiesExtendedResponse = DeploymentPropertiesExtendedResponse(
            correlationId = javaType.correlationId(),
            debugSetting = javaType.debugSetting().let({ args0 ->
                com.pulumi.azurenative.resources.kotlin.outputs.DebugSettingResponse.Companion.toKotlin(args0)
            }),
            dependencies = javaType.dependencies().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.resources.kotlin.outputs.DependencyResponse.Companion.toKotlin(args0)
                })
            }),
            duration = javaType.duration(),
            error = javaType.error().let({ args0 ->
                com.pulumi.azurenative.resources.kotlin.outputs.ErrorResponseResponse.Companion.toKotlin(args0)
            }),
            mode = javaType.mode(),
            onErrorDeployment = javaType.onErrorDeployment().let({ args0 ->
                com.pulumi.azurenative.resources.kotlin.outputs.OnErrorDeploymentExtendedResponse.Companion.toKotlin(args0)
            }),
            outputResources = javaType.outputResources().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.resources.kotlin.outputs.ResourceReferenceResponse.Companion.toKotlin(args0)
                })
            }),
            outputs = javaType.outputs(),
            parameters = javaType.parameters(),
            parametersLink = javaType.parametersLink().let({ args0 ->
                com.pulumi.azurenative.resources.kotlin.outputs.ParametersLinkResponse.Companion.toKotlin(args0)
            }),
            providers = javaType.providers().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.resources.kotlin.outputs.ProviderResponse.Companion.toKotlin(args0)
                })
            }),
            provisioningState = javaType.provisioningState(),
            templateHash = javaType.templateHash(),
            templateLink = javaType.templateLink().let({ args0 ->
                com.pulumi.azurenative.resources.kotlin.outputs.TemplateLinkResponse.Companion.toKotlin(args0)
            }),
            timestamp = javaType.timestamp(),
            validatedResources = javaType.validatedResources().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.resources.kotlin.outputs.ResourceReferenceResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
