@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.resources.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Defines the behavior of resources that are not managed immediately after the stack is updated.
 * @property managementGroups Specifies the action that should be taken on the resource when the deployment stack is deleted. Delete will attempt to delete the resource from Azure. Detach will leave the resource in it's current state.
 * @property resourceGroups Specifies the action that should be taken on the resource when the deployment stack is deleted. Delete will attempt to delete the resource from Azure. Detach will leave the resource in it's current state.
 * @property resources Specifies the action that should be taken on the resource when the deployment stack is deleted. Delete will attempt to delete the resource from Azure. Detach will leave the resource in it's current state.
 */
public data class DeploymentStackPropertiesResponseActionOnUnmanage(
    public val managementGroups: String? = null,
    public val resourceGroups: String? = null,
    public val resources: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.resources.outputs.DeploymentStackPropertiesResponseActionOnUnmanage): DeploymentStackPropertiesResponseActionOnUnmanage =
            DeploymentStackPropertiesResponseActionOnUnmanage(
                managementGroups = javaType.managementGroups().map({ args0 -> args0 }).orElse(null),
                resourceGroups = javaType.resourceGroups().map({ args0 -> args0 }).orElse(null),
                resources = javaType.resources(),
            )
    }
}
