@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.resources.kotlin.outputs

import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Object model for the Azure PowerShell script.
 * @property arguments Command line arguments to pass to the script. Arguments are separated by spaces. ex: -Name blue* -Location 'West US 2'
 * @property azPowerShellVersion Azure PowerShell module version to be used.
 * @property cleanupPreference The clean up preference when the script execution gets in a terminal state. Default setting is 'Always'.
 * @property containerSettings Container settings.
 * @property environmentVariables The environment variables to pass over to the script.
 * @property forceUpdateTag Gets or sets how the deployment script should be forced to execute even if the script resource has not changed. Can be current time stamp or a GUID.
 * @property id String Id used to locate any resource on Azure.
 * @property identity Optional property. Managed identity to be used for this deployment script. Currently, only user-assigned MSI is supported.
 * @property kind Type of the script.
 * Expected value is 'AzurePowerShell'.
 * @property location The location of the ACI and the storage account for the deployment script.
 * @property name Name of this resource.
 * @property outputs List of script outputs.
 * @property primaryScriptUri Uri for the script. This is the entry point for the external script.
 * @property provisioningState State of the script execution. This only appears in the response.
 * @property retentionInterval Interval for which the service retains the script resource after it reaches a terminal state. Resource will be deleted when this duration expires. Duration is based on ISO 8601 pattern (for example P1D means one day).
 * @property scriptContent Script body.
 * @property status Contains the results of script execution.
 * @property storageAccountSettings Storage Account settings.
 * @property supportingScriptUris Supporting files for the external script.
 * @property systemData The system metadata related to this resource.
 * @property tags Resource tags.
 * @property timeout Maximum allowed script execution time specified in ISO 8601 format. Default value is P1D
 * @property type Type of this resource.
 */
public data class GetAzurePowerShellScriptResult(
    public val arguments: String? = null,
    public val azPowerShellVersion: String,
    public val cleanupPreference: String? = null,
    public val containerSettings: ContainerConfigurationResponse? = null,
    public val environmentVariables: List<EnvironmentVariableResponse>? = null,
    public val forceUpdateTag: String? = null,
    public val id: String,
    public val identity: ManagedServiceIdentityResponse? = null,
    public val kind: String,
    public val location: String,
    public val name: String,
    public val outputs: Map<String, Any>,
    public val primaryScriptUri: String? = null,
    public val provisioningState: String,
    public val retentionInterval: String,
    public val scriptContent: String? = null,
    public val status: ScriptStatusResponse,
    public val storageAccountSettings: StorageAccountConfigurationResponse? = null,
    public val supportingScriptUris: List<String>? = null,
    public val systemData: SystemDataResponse,
    public val tags: Map<String, String>? = null,
    public val timeout: String? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.resources.outputs.GetAzurePowerShellScriptResult): GetAzurePowerShellScriptResult = GetAzurePowerShellScriptResult(
            arguments = javaType.arguments().map({ args0 -> args0 }).orElse(null),
            azPowerShellVersion = javaType.azPowerShellVersion(),
            cleanupPreference = javaType.cleanupPreference().map({ args0 -> args0 }).orElse(null),
            containerSettings = javaType.containerSettings().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.resources.kotlin.outputs.ContainerConfigurationResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            environmentVariables = javaType.environmentVariables().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.resources.kotlin.outputs.EnvironmentVariableResponse.Companion.toKotlin(args0)
                })
            }),
            forceUpdateTag = javaType.forceUpdateTag().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            identity = javaType.identity().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.resources.kotlin.outputs.ManagedServiceIdentityResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            kind = javaType.kind(),
            location = javaType.location(),
            name = javaType.name(),
            outputs = javaType.outputs().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            primaryScriptUri = javaType.primaryScriptUri().map({ args0 -> args0 }).orElse(null),
            provisioningState = javaType.provisioningState(),
            retentionInterval = javaType.retentionInterval(),
            scriptContent = javaType.scriptContent().map({ args0 -> args0 }).orElse(null),
            status = javaType.status().let({ args0 ->
                com.pulumi.azurenative.resources.kotlin.outputs.ScriptStatusResponse.Companion.toKotlin(args0)
            }),
            storageAccountSettings = javaType.storageAccountSettings().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.resources.kotlin.outputs.StorageAccountConfigurationResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            supportingScriptUris = javaType.supportingScriptUris().map({ args0 -> args0 }),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.resources.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            timeout = javaType.timeout().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
        )
    }
}
