@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.resources.kotlin.outputs

import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Deployment stack object.
 * @property actionOnUnmanage Defines the behavior of resources that are not managed immediately after the stack is updated.
 * @property debugSetting The debug setting of the deployment.
 * @property deletedResources An array of resources that were deleted during the most recent update.
 * @property denySettings Defines how resources deployed by the stack are locked.
 * @property deploymentId The resourceId of the deployment resource created by the deployment stack.
 * @property deploymentScope The scope at which the initial deployment should be created. If a scope is not specified, it will default to the scope of the deployment stack. Valid scopes are: management group (format: '/providers/Microsoft.Management/managementGroups/{managementGroupId}'), subscription (format: '/subscriptions/{subscriptionId}'), resource group (format: '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}').
 * @property description Deployment stack description.
 * @property detachedResources An array of resources that were detached during the most recent update.
 * @property duration The duration of the deployment stack update.
 * @property error Common error response for all Azure Resource Manager APIs to return error details for failed operations. (This also follows the OData error response format.).
 * @property failedResources An array of resources that failed to reach goal state during the most recent update.
 * @property id String Id used to locate any resource on Azure.
 * @property location The location of the deployment stack. It cannot be changed after creation. It must be one of the supported Azure locations.
 * @property name Name of this resource.
 * @property outputs The outputs of the underlying deployment.
 * @property parameters Name and value pairs that define the deployment parameters for the template. Use this element when providing the parameter values directly in the request, rather than linking to an existing parameter file. Use either the parametersLink property or the parameters property, but not both. It can be a JObject or a well formed JSON string.
 * @property parametersLink The URI of parameters file. Use this element to link to an existing parameters file. Use either the parametersLink property or the parameters property, but not both.
 * @property provisioningState State of the deployment stack.
 * @property resources An array of resources currently managed by the deployment stack.
 * @property systemData Azure Resource Manager metadata containing createdBy and modifiedBy information.
 * @property tags Deployment stack resource tags.
 * @property type Type of this resource.
 */
public data class GetDeploymentStackAtResourceGroupResult(
    public val actionOnUnmanage: DeploymentStackPropertiesResponseActionOnUnmanage,
    public val debugSetting: DeploymentStacksDebugSettingResponse? = null,
    public val deletedResources: List<ResourceReferenceResponse>,
    public val denySettings: DenySettingsResponse,
    public val deploymentId: String,
    public val deploymentScope: String? = null,
    public val description: String? = null,
    public val detachedResources: List<ResourceReferenceResponse>,
    public val duration: String,
    public val error: ErrorResponseResponse? = null,
    public val failedResources: List<ResourceReferenceExtendedResponse>,
    public val id: String,
    public val location: String? = null,
    public val name: String,
    public val outputs: Any,
    public val parameters: Any? = null,
    public val parametersLink: DeploymentStacksParametersLinkResponse? = null,
    public val provisioningState: String,
    public val resources: List<ManagedResourceReferenceResponse>,
    public val systemData: SystemDataResponse,
    public val tags: Map<String, String>? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.resources.outputs.GetDeploymentStackAtResourceGroupResult): GetDeploymentStackAtResourceGroupResult = GetDeploymentStackAtResourceGroupResult(
            actionOnUnmanage = javaType.actionOnUnmanage().let({ args0 ->
                com.pulumi.azurenative.resources.kotlin.outputs.DeploymentStackPropertiesResponseActionOnUnmanage.Companion.toKotlin(args0)
            }),
            debugSetting = javaType.debugSetting().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.resources.kotlin.outputs.DeploymentStacksDebugSettingResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            deletedResources = javaType.deletedResources().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.resources.kotlin.outputs.ResourceReferenceResponse.Companion.toKotlin(args0)
                })
            }),
            denySettings = javaType.denySettings().let({ args0 ->
                com.pulumi.azurenative.resources.kotlin.outputs.DenySettingsResponse.Companion.toKotlin(args0)
            }),
            deploymentId = javaType.deploymentId(),
            deploymentScope = javaType.deploymentScope().map({ args0 -> args0 }).orElse(null),
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            detachedResources = javaType.detachedResources().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.resources.kotlin.outputs.ResourceReferenceResponse.Companion.toKotlin(args0)
                })
            }),
            duration = javaType.duration(),
            error = javaType.error().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.resources.kotlin.outputs.ErrorResponseResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            failedResources = javaType.failedResources().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.resources.kotlin.outputs.ResourceReferenceExtendedResponse.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id(),
            location = javaType.location().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            outputs = javaType.outputs(),
            parameters = javaType.parameters().map({ args0 -> args0 }).orElse(null),
            parametersLink = javaType.parametersLink().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.resources.kotlin.outputs.DeploymentStacksParametersLinkResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            provisioningState = javaType.provisioningState(),
            resources = javaType.resources().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.resources.kotlin.outputs.ManagedResourceReferenceResponse.Companion.toKotlin(args0)
                })
            }),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.resources.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
        )
    }
}
