@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.resources.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * Resource group information.
 * @property id The ID of the resource group.
 * @property location The location of the resource group. It cannot be changed after the resource group has been created. It must be one of the supported Azure locations.
 * @property managedBy The ID of the resource that manages this resource group.
 * @property name The name of the resource group.
 * @property properties The resource group properties.
 * @property tags The tags attached to the resource group.
 * @property type The type of the resource group.
 */
public data class GetResourceGroupResult(
    public val id: String,
    public val location: String,
    public val managedBy: String? = null,
    public val name: String,
    public val properties: ResourceGroupPropertiesResponse,
    public val tags: Map<String, String>? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.resources.outputs.GetResourceGroupResult): GetResourceGroupResult = GetResourceGroupResult(
            id = javaType.id(),
            location = javaType.location(),
            managedBy = javaType.managedBy().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            properties = javaType.properties().let({ args0 ->
                com.pulumi.azurenative.resources.kotlin.outputs.ResourceGroupPropertiesResponse.Companion.toKotlin(args0)
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
        )
    }
}
