@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.resources.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Wrapper resource for tags API requests and responses.
 * @property id The ID of the tags wrapper resource.
 * @property name The name of the tags wrapper resource.
 * @property properties The set of tags.
 * @property type The type of the tags wrapper resource.
 */
public data class GetTagAtScopeResult(
    public val id: String,
    public val name: String,
    public val properties: TagsResponse,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.resources.outputs.GetTagAtScopeResult): GetTagAtScopeResult = GetTagAtScopeResult(
            id = javaType.id(),
            name = javaType.name(),
            properties = javaType.properties().let({ args0 ->
                com.pulumi.azurenative.resources.kotlin.outputs.TagsResponse.Companion.toKotlin(args0)
            }),
            type = javaType.type(),
        )
    }
}
