@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.resources.kotlin.outputs

import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * Template Spec object.
 * @property description Template Spec description.
 * @property displayName Template Spec display name.
 * @property id String Id used to locate any resource on Azure.
 * @property location The location of the Template Spec. It cannot be changed after Template Spec creation. It must be one of the supported Azure locations.
 * @property metadata The Template Spec metadata. Metadata is an open-ended object and is typically a collection of key-value pairs.
 * @property name Name of this resource.
 * @property systemData Azure Resource Manager metadata containing createdBy and modifiedBy information.
 * @property tags Resource tags.
 * @property type Type of this resource.
 * @property versions High-level information about the versions within this Template Spec. The keys are the version names. Only populated if the $expand query parameter is set to 'versions'.
 */
public data class GetTemplateSpecResult(
    public val description: String? = null,
    public val displayName: String? = null,
    public val id: String,
    public val location: String,
    public val metadata: Any? = null,
    public val name: String,
    public val systemData: SystemDataResponse,
    public val tags: Map<String, String>? = null,
    public val type: String,
    public val versions: Map<String, TemplateSpecVersionInfoResponse>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.resources.outputs.GetTemplateSpecResult): GetTemplateSpecResult = GetTemplateSpecResult(
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            displayName = javaType.displayName().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            location = javaType.location(),
            metadata = javaType.metadata().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.resources.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
            versions = javaType.versions().map({ args0 ->
                args0.key.to(
                    args0.value.let({ args0 ->
                        com.pulumi.azurenative.resources.kotlin.outputs.TemplateSpecVersionInfoResponse.Companion.toKotlin(args0)
                    }),
                )
            }).toMap(),
        )
    }
}
