@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.resources.kotlin.outputs

import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Template Spec Version object.
 * @property description Template Spec version description.
 * @property id String Id used to locate any resource on Azure.
 * @property linkedTemplates An array of linked template artifacts.
 * @property location The location of the Template Spec Version. It must match the location of the parent Template Spec.
 * @property mainTemplate The main Azure Resource Manager template content.
 * @property metadata The version metadata. Metadata is an open-ended object and is typically a collection of key-value pairs.
 * @property name Name of this resource.
 * @property systemData Azure Resource Manager metadata containing createdBy and modifiedBy information.
 * @property tags Resource tags.
 * @property type Type of this resource.
 * @property uiFormDefinition The Azure Resource Manager template UI definition content.
 */
public data class GetTemplateSpecVersionResult(
    public val description: String? = null,
    public val id: String,
    public val linkedTemplates: List<LinkedTemplateArtifactResponse>? = null,
    public val location: String,
    public val mainTemplate: Any? = null,
    public val metadata: Any? = null,
    public val name: String,
    public val systemData: SystemDataResponse,
    public val tags: Map<String, String>? = null,
    public val type: String,
    public val uiFormDefinition: Any? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.resources.outputs.GetTemplateSpecVersionResult): GetTemplateSpecVersionResult = GetTemplateSpecVersionResult(
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            linkedTemplates = javaType.linkedTemplates().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.resources.kotlin.outputs.LinkedTemplateArtifactResponse.Companion.toKotlin(args0)
                })
            }),
            location = javaType.location(),
            mainTemplate = javaType.mainTemplate().map({ args0 -> args0 }).orElse(null),
            metadata = javaType.metadata().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.resources.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
            uiFormDefinition = javaType.uiFormDefinition().map({ args0 -> args0 }).orElse(null),
        )
    }
}
