@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.resources.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The managed resource model.
 * @property denyStatus denyAssignment settings applied to the resource.
 * @property id The resourceId of a resource managed by the deployment stack.
 * @property status Current management state of the resource in the deployment stack.
 */
public data class ManagedResourceReferenceResponse(
    public val denyStatus: String? = null,
    public val id: String,
    public val status: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.resources.outputs.ManagedResourceReferenceResponse): ManagedResourceReferenceResponse = ManagedResourceReferenceResponse(
            denyStatus = javaType.denyStatus().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            status = javaType.status().map({ args0 -> args0 }).orElse(null),
        )
    }
}
