@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.resources.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Deployment on error behavior with additional details.
 * @property deploymentName The deployment to be used on error case.
 * @property provisioningState The state of the provisioning for the on error deployment.
 * @property type The deployment on error behavior type. Possible values are LastSuccessful and SpecificDeployment.
 */
public data class OnErrorDeploymentExtendedResponse(
    public val deploymentName: String? = null,
    public val provisioningState: String,
    public val type: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.resources.outputs.OnErrorDeploymentExtendedResponse): OnErrorDeploymentExtendedResponse = OnErrorDeploymentExtendedResponse(
            deploymentName = javaType.deploymentName().map({ args0 -> args0 }).orElse(null),
            provisioningState = javaType.provisioningState(),
            type = javaType.type().map({ args0 -> args0 }).orElse(null),
        )
    }
}
