@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.resources.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Plan for the resource.
 * @property name The plan ID.
 * @property product The offer ID.
 * @property promotionCode The promotion code.
 * @property publisher The publisher ID.
 * @property version The plan's version.
 */
public data class PlanResponse(
    public val name: String? = null,
    public val product: String? = null,
    public val promotionCode: String? = null,
    public val publisher: String? = null,
    public val version: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.resources.outputs.PlanResponse): PlanResponse = PlanResponse(
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            product = javaType.product().map({ args0 -> args0 }).orElse(null),
            promotionCode = javaType.promotionCode().map({ args0 -> args0 }).orElse(null),
            publisher = javaType.publisher().map({ args0 -> args0 }).orElse(null),
            version = javaType.version().map({ args0 -> args0 }).orElse(null),
        )
    }
}
