@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.resources.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * The provider extended location.
 * @property extendedLocations The extended locations for the azure location.
 * @property location The azure location.
 * @property type The extended location type.
 */
public data class ProviderExtendedLocationResponse(
    public val extendedLocations: List<String>? = null,
    public val location: String? = null,
    public val type: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.resources.outputs.ProviderExtendedLocationResponse): ProviderExtendedLocationResponse = ProviderExtendedLocationResponse(
            extendedLocations = javaType.extendedLocations().map({ args0 -> args0 }),
            location = javaType.location().map({ args0 -> args0 }).orElse(null),
            type = javaType.type().map({ args0 -> args0 }).orElse(null),
        )
    }
}
