@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.resources.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Settings to use an existing storage account. Valid storage account kinds are: Storage, StorageV2 and FileStorage
 * @property storageAccountKey The storage account access key.
 * @property storageAccountName The storage account name.
 */
public data class StorageAccountConfigurationResponse(
    public val storageAccountKey: String? = null,
    public val storageAccountName: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.resources.outputs.StorageAccountConfigurationResponse): StorageAccountConfigurationResponse = StorageAccountConfigurationResponse(
            storageAccountKey = javaType.storageAccountKey().map({ args0 -> args0 }).orElse(null),
            storageAccountName = javaType.storageAccountName().map({ args0 -> args0 }).orElse(null),
        )
    }
}
