@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.resources.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Entity representing the reference to the template.
 * @property contentVersion If included, must match the ContentVersion in the template.
 * @property id The resource id of a Template Spec. Use either the id or uri property, but not both.
 * @property queryString The query string (for example, a SAS token) to be used with the templateLink URI.
 * @property relativePath The relativePath property can be used to deploy a linked template at a location relative to the parent. If the parent template was linked with a TemplateSpec, this will reference an artifact in the TemplateSpec.  If the parent was linked with a URI, the child deployment will be a combination of the parent and relativePath URIs
 * @property uri The URI of the template to deploy. Use either the uri or id property, but not both.
 */
public data class TemplateLinkResponse(
    public val contentVersion: String? = null,
    public val id: String? = null,
    public val queryString: String? = null,
    public val relativePath: String? = null,
    public val uri: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.resources.outputs.TemplateLinkResponse): TemplateLinkResponse = TemplateLinkResponse(
            contentVersion = javaType.contentVersion().map({ args0 -> args0 }).orElse(null),
            id = javaType.id().map({ args0 -> args0 }).orElse(null),
            queryString = javaType.queryString().map({ args0 -> args0 }).orElse(null),
            relativePath = javaType.relativePath().map({ args0 -> args0 }).orElse(null),
            uri = javaType.uri().map({ args0 -> args0 }).orElse(null),
        )
    }
}
