@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.resources.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * User-assigned managed identity.
 * @property clientId Client App Id associated with this identity.
 * @property principalId Azure Active Directory principal ID associated with this identity.
 */
public data class UserAssignedIdentityResponse(
    public val clientId: String,
    public val principalId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.resources.outputs.UserAssignedIdentityResponse): UserAssignedIdentityResponse = UserAssignedIdentityResponse(
            clientId = javaType.clientId(),
            principalId = javaType.principalId(),
        )
    }
}
