@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.resources.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property location The location of the zone mapping.
 * @property zones
 */
public data class ZoneMappingResponse(
    public val location: String? = null,
    public val zones: List<String>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.resources.outputs.ZoneMappingResponse): ZoneMappingResponse = ZoneMappingResponse(
            location = javaType.location().map({ args0 -> args0 }).orElse(null),
            zones = javaType.zones().map({ args0 -> args0 }),
        )
    }
}
