@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.saas.kotlin.inputs

import com.pulumi.azurenative.saas.inputs.ListSaasSubscriptionLevelAccessTokenPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property resourceGroupName The name of the resource group.
 * @property resourceName The name of the resource.
 */
public data class ListSaasSubscriptionLevelAccessTokenPlainArgs(
    public val resourceGroupName: String,
    public val resourceName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.saas.inputs.ListSaasSubscriptionLevelAccessTokenPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.saas.inputs.ListSaasSubscriptionLevelAccessTokenPlainArgs =
        com.pulumi.azurenative.saas.inputs.ListSaasSubscriptionLevelAccessTokenPlainArgs.builder()
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .resourceName(resourceName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [ListSaasSubscriptionLevelAccessTokenPlainArgs].
 */
@PulumiTagMarker
public class ListSaasSubscriptionLevelAccessTokenPlainArgsBuilder internal constructor() {
    private var resourceGroupName: String? = null

    private var resourceName: String? = null

    /**
     * @param value The name of the resource group.
     */
    @JvmName("dunkhsghqxyrebpl")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the resource.
     */
    @JvmName("bhrtcwoekdipojnu")
    public suspend fun resourceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceName = mapped
    }

    internal fun build(): ListSaasSubscriptionLevelAccessTokenPlainArgs =
        ListSaasSubscriptionLevelAccessTokenPlainArgs(
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
            resourceName = resourceName ?: throw PulumiNullFieldException("resourceName"),
        )
}
