@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.saas.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * the ISV access token result response.
 * @property publisherOfferBaseUri The Publisher Offer Base Uri
 * @property token The generated token
 */
public data class ListSaasSubscriptionLevelAccessTokenResult(
    public val publisherOfferBaseUri: String? = null,
    public val token: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.saas.outputs.ListSaasSubscriptionLevelAccessTokenResult): ListSaasSubscriptionLevelAccessTokenResult = ListSaasSubscriptionLevelAccessTokenResult(
            publisherOfferBaseUri = javaType.publisherOfferBaseUri().map({ args0 -> args0 }).orElse(null),
            token = javaType.token().map({ args0 -> args0 }).orElse(null),
        )
    }
}
