@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.scheduler.kotlin

import com.pulumi.azurenative.scheduler.kotlin.outputs.JobCollectionPropertiesResponse
import com.pulumi.azurenative.scheduler.kotlin.outputs.JobCollectionPropertiesResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [JobCollection].
 */
@PulumiTagMarker
public class JobCollectionResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: JobCollectionArgs = JobCollectionArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend JobCollectionArgsBuilder.() -> Unit) {
        val builder = JobCollectionArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): JobCollection {
        val builtJavaResource = com.pulumi.azurenative.scheduler.JobCollection(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return JobCollection(builtJavaResource)
    }
}

/**
 *
 * Azure REST API version: 2016-03-01. Prior API version in Azure Native 1.x: 2016-03-01.
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:scheduler:JobCollection myresource1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Scheduler/jobCollections/{jobCollectionName}
 * ```
 */
public class JobCollection internal constructor(
    override val javaResource: com.pulumi.azurenative.scheduler.JobCollection,
) : KotlinCustomResource(javaResource, JobCollectionMapper) {
    /**
     * Gets or sets the storage account location.
     */
    public val location: Output<String>?
        get() = javaResource.location().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Gets or sets the job collection resource name.
     */
    public val name: Output<String>?
        get() = javaResource.name().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Gets or sets the job collection properties.
     */
    public val properties: Output<JobCollectionPropertiesResponse>
        get() = javaResource.properties().applyValue({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })

    /**
     * Gets or sets the tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Gets the job collection resource type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object JobCollectionMapper : ResourceMapper<JobCollection> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.scheduler.JobCollection::class == javaResource::class

    override fun map(javaResource: Resource): JobCollection = JobCollection(
        javaResource as
            com.pulumi.azurenative.scheduler.JobCollection,
    )
}

/**
 * @see [JobCollection].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [JobCollection].
 */
public suspend fun jobCollection(
    name: String,
    block: suspend JobCollectionResourceBuilder.() -> Unit,
): JobCollection {
    val builder = JobCollectionResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [JobCollection].
 * @param name The _unique_ name of the resulting resource.
 */
public fun jobCollection(name: String): JobCollection {
    val builder = JobCollectionResourceBuilder()
    builder.name(name)
    return builder.build()
}
