@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.scheduler.kotlin.inputs

import com.pulumi.azurenative.scheduler.inputs.GetJobCollectionPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property jobCollectionName The job collection name.
 * @property resourceGroupName The resource group name.
 */
public data class GetJobCollectionPlainArgs(
    public val jobCollectionName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.scheduler.inputs.GetJobCollectionPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.scheduler.inputs.GetJobCollectionPlainArgs =
        com.pulumi.azurenative.scheduler.inputs.GetJobCollectionPlainArgs.builder()
            .jobCollectionName(jobCollectionName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetJobCollectionPlainArgs].
 */
@PulumiTagMarker
public class GetJobCollectionPlainArgsBuilder internal constructor() {
    private var jobCollectionName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The job collection name.
     */
    @JvmName("owvasylgpkpsinld")
    public suspend fun jobCollectionName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.jobCollectionName = mapped
    }

    /**
     * @param value The resource group name.
     */
    @JvmName("dhpyxptcmrtkqpkp")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetJobCollectionPlainArgs = GetJobCollectionPlainArgs(
        jobCollectionName = jobCollectionName ?: throw PulumiNullFieldException("jobCollectionName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
