@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.scheduler.kotlin.inputs

import com.pulumi.azurenative.scheduler.inputs.JobRecurrenceScheduleArgs.builder
import com.pulumi.azurenative.scheduler.kotlin.enums.DayOfWeek
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property hours Gets or sets the hours of the day that the job should execute at.
 * @property minutes Gets or sets the minutes of the hour that the job should execute at.
 * @property monthDays Gets or sets the days of the month that the job should execute on. Must be between 1 and 31.
 * @property monthlyOccurrences Gets or sets the occurrences of days within a month.
 * @property weekDays Gets or sets the days of the week that the job should execute on.
 */
public data class JobRecurrenceScheduleArgs(
    public val hours: Output<List<Int>>? = null,
    public val minutes: Output<List<Int>>? = null,
    public val monthDays: Output<List<Int>>? = null,
    public val monthlyOccurrences: Output<List<JobRecurrenceScheduleMonthlyOccurrenceArgs>>? = null,
    public val weekDays: Output<List<DayOfWeek>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.scheduler.inputs.JobRecurrenceScheduleArgs> {
    override fun toJava(): com.pulumi.azurenative.scheduler.inputs.JobRecurrenceScheduleArgs =
        com.pulumi.azurenative.scheduler.inputs.JobRecurrenceScheduleArgs.builder()
            .hours(hours?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .minutes(minutes?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .monthDays(monthDays?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .monthlyOccurrences(
                monthlyOccurrences?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .weekDays(
                weekDays?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [JobRecurrenceScheduleArgs].
 */
@PulumiTagMarker
public class JobRecurrenceScheduleArgsBuilder internal constructor() {
    private var hours: Output<List<Int>>? = null

    private var minutes: Output<List<Int>>? = null

    private var monthDays: Output<List<Int>>? = null

    private var monthlyOccurrences: Output<List<JobRecurrenceScheduleMonthlyOccurrenceArgs>>? = null

    private var weekDays: Output<List<DayOfWeek>>? = null

    /**
     * @param value Gets or sets the hours of the day that the job should execute at.
     */
    @JvmName("qdiexglpirsiigos")
    public suspend fun hours(`value`: Output<List<Int>>) {
        this.hours = value
    }

    @JvmName("rgvlysasigvljunf")
    public suspend fun hours(vararg values: Output<Int>) {
        this.hours = Output.all(values.asList())
    }

    /**
     * @param values Gets or sets the hours of the day that the job should execute at.
     */
    @JvmName("slkwrnrwlmdtnedf")
    public suspend fun hours(values: List<Output<Int>>) {
        this.hours = Output.all(values)
    }

    /**
     * @param value Gets or sets the minutes of the hour that the job should execute at.
     */
    @JvmName("dpgqgynhfujjwvfa")
    public suspend fun minutes(`value`: Output<List<Int>>) {
        this.minutes = value
    }

    @JvmName("lndsroqwuvlwdjmg")
    public suspend fun minutes(vararg values: Output<Int>) {
        this.minutes = Output.all(values.asList())
    }

    /**
     * @param values Gets or sets the minutes of the hour that the job should execute at.
     */
    @JvmName("kaxmgfarhdrtivkx")
    public suspend fun minutes(values: List<Output<Int>>) {
        this.minutes = Output.all(values)
    }

    /**
     * @param value Gets or sets the days of the month that the job should execute on. Must be between 1 and 31.
     */
    @JvmName("atbmsjuvxsxyahjb")
    public suspend fun monthDays(`value`: Output<List<Int>>) {
        this.monthDays = value
    }

    @JvmName("mfdlybkpjaaluryd")
    public suspend fun monthDays(vararg values: Output<Int>) {
        this.monthDays = Output.all(values.asList())
    }

    /**
     * @param values Gets or sets the days of the month that the job should execute on. Must be between 1 and 31.
     */
    @JvmName("pceptmswtlqcrcxy")
    public suspend fun monthDays(values: List<Output<Int>>) {
        this.monthDays = Output.all(values)
    }

    /**
     * @param value Gets or sets the occurrences of days within a month.
     */
    @JvmName("exktvernlyxglxfw")
    public suspend fun monthlyOccurrences(`value`: Output<List<JobRecurrenceScheduleMonthlyOccurrenceArgs>>) {
        this.monthlyOccurrences = value
    }

    @JvmName("bujnmbtfaefjttxn")
    public suspend fun monthlyOccurrences(vararg values: Output<JobRecurrenceScheduleMonthlyOccurrenceArgs>) {
        this.monthlyOccurrences = Output.all(values.asList())
    }

    /**
     * @param values Gets or sets the occurrences of days within a month.
     */
    @JvmName("gbiipxmvhayqoysg")
    public suspend fun monthlyOccurrences(values: List<Output<JobRecurrenceScheduleMonthlyOccurrenceArgs>>) {
        this.monthlyOccurrences = Output.all(values)
    }

    /**
     * @param value Gets or sets the days of the week that the job should execute on.
     */
    @JvmName("fqmtodqmrpnqgtwm")
    public suspend fun weekDays(`value`: Output<List<DayOfWeek>>) {
        this.weekDays = value
    }

    @JvmName("hufibiqbsjpkaeil")
    public suspend fun weekDays(vararg values: Output<DayOfWeek>) {
        this.weekDays = Output.all(values.asList())
    }

    /**
     * @param values Gets or sets the days of the week that the job should execute on.
     */
    @JvmName("kwwjavjoirxlxyys")
    public suspend fun weekDays(values: List<Output<DayOfWeek>>) {
        this.weekDays = Output.all(values)
    }

    /**
     * @param value Gets or sets the hours of the day that the job should execute at.
     */
    @JvmName("rhwhjydmrkhgngoa")
    public suspend fun hours(`value`: List<Int>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hours = mapped
    }

    /**
     * @param values Gets or sets the hours of the day that the job should execute at.
     */
    @JvmName("jgqynsqafitnqfeh")
    public suspend fun hours(vararg values: Int) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.hours = mapped
    }

    /**
     * @param value Gets or sets the minutes of the hour that the job should execute at.
     */
    @JvmName("luxpyfxhjhnylifg")
    public suspend fun minutes(`value`: List<Int>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.minutes = mapped
    }

    /**
     * @param values Gets or sets the minutes of the hour that the job should execute at.
     */
    @JvmName("kcfuxcsdxmwvetau")
    public suspend fun minutes(vararg values: Int) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.minutes = mapped
    }

    /**
     * @param value Gets or sets the days of the month that the job should execute on. Must be between 1 and 31.
     */
    @JvmName("tswysrhhfrgykckl")
    public suspend fun monthDays(`value`: List<Int>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.monthDays = mapped
    }

    /**
     * @param values Gets or sets the days of the month that the job should execute on. Must be between 1 and 31.
     */
    @JvmName("bofxbkxjpemgqves")
    public suspend fun monthDays(vararg values: Int) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.monthDays = mapped
    }

    /**
     * @param value Gets or sets the occurrences of days within a month.
     */
    @JvmName("vpdmqywsvclaaxrg")
    public suspend fun monthlyOccurrences(`value`: List<JobRecurrenceScheduleMonthlyOccurrenceArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.monthlyOccurrences = mapped
    }

    /**
     * @param argument Gets or sets the occurrences of days within a month.
     */
    @JvmName("mfrhsqtyxfkuthep")
    public suspend fun monthlyOccurrences(argument: List<suspend JobRecurrenceScheduleMonthlyOccurrenceArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            JobRecurrenceScheduleMonthlyOccurrenceArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.monthlyOccurrences = mapped
    }

    /**
     * @param argument Gets or sets the occurrences of days within a month.
     */
    @JvmName("eqhusxgwpvrrrsbq")
    public suspend fun monthlyOccurrences(vararg argument: suspend JobRecurrenceScheduleMonthlyOccurrenceArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            JobRecurrenceScheduleMonthlyOccurrenceArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.monthlyOccurrences = mapped
    }

    /**
     * @param argument Gets or sets the occurrences of days within a month.
     */
    @JvmName("trhttshmvltehmrh")
    public suspend fun monthlyOccurrences(argument: suspend JobRecurrenceScheduleMonthlyOccurrenceArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            JobRecurrenceScheduleMonthlyOccurrenceArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.monthlyOccurrences = mapped
    }

    /**
     * @param values Gets or sets the occurrences of days within a month.
     */
    @JvmName("tirkvsjgwmtkhctw")
    public suspend fun monthlyOccurrences(vararg values: JobRecurrenceScheduleMonthlyOccurrenceArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.monthlyOccurrences = mapped
    }

    /**
     * @param value Gets or sets the days of the week that the job should execute on.
     */
    @JvmName("lmjohwhekxuswkof")
    public suspend fun weekDays(`value`: List<DayOfWeek>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.weekDays = mapped
    }

    /**
     * @param values Gets or sets the days of the week that the job should execute on.
     */
    @JvmName("jkwrnlbslvhorvau")
    public suspend fun weekDays(vararg values: DayOfWeek) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.weekDays = mapped
    }

    internal fun build(): JobRecurrenceScheduleArgs = JobRecurrenceScheduleArgs(
        hours = hours,
        minutes = minutes,
        monthDays = monthDays,
        monthlyOccurrences = monthlyOccurrences,
        weekDays = weekDays,
    )
}
