@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.scheduler.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 *
 * @property id Gets the job collection resource identifier.
 * @property location Gets or sets the storage account location.
 * @property name Gets or sets the job collection resource name.
 * @property properties Gets or sets the job collection properties.
 * @property tags Gets or sets the tags.
 * @property type Gets the job collection resource type.
 */
public data class GetJobCollectionResult(
    public val id: String,
    public val location: String? = null,
    public val name: String? = null,
    public val properties: JobCollectionPropertiesResponse,
    public val tags: Map<String, String>? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.scheduler.outputs.GetJobCollectionResult): GetJobCollectionResult = GetJobCollectionResult(
            id = javaType.id(),
            location = javaType.location().map({ args0 -> args0 }).orElse(null),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            properties = javaType.properties().let({ args0 ->
                com.pulumi.azurenative.scheduler.kotlin.outputs.JobCollectionPropertiesResponse.Companion.toKotlin(args0)
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
        )
    }
}
