@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.scheduler.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property id Gets the job resource identifier.
 * @property name Gets the job resource name.
 * @property properties Gets or sets the job properties.
 * @property type Gets the job resource type.
 */
public data class GetJobResult(
    public val id: String,
    public val name: String,
    public val properties: JobPropertiesResponse,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.scheduler.outputs.GetJobResult): GetJobResult = GetJobResult(
            id = javaType.id(),
            name = javaType.name(),
            properties = javaType.properties().let({ args0 ->
                com.pulumi.azurenative.scheduler.kotlin.outputs.JobPropertiesResponse.Companion.toKotlin(args0)
            }),
            type = javaType.type(),
        )
    }
}
