@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.scheduler.kotlin.outputs

import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 *
 * @property authentication Gets or sets the authentication method of the request.
 * @property body Gets or sets the request body.
 * @property headers Gets or sets the headers.
 * @property method Gets or sets the method of the request.
 * @property uri Gets or sets the URI of the request.
 */
public data class HttpRequestResponse(
    public val authentication: Any? = null,
    public val body: String? = null,
    public val headers: Map<String, String>? = null,
    public val method: String? = null,
    public val uri: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.scheduler.outputs.HttpRequestResponse): HttpRequestResponse = HttpRequestResponse(
            authentication = javaType.authentication().map({ args0 -> args0 }).orElse(null),
            body = javaType.body().map({ args0 -> args0 }).orElse(null),
            headers = javaType.headers().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            method = javaType.method().map({ args0 -> args0 }).orElse(null),
            uri = javaType.uri().map({ args0 -> args0 }).orElse(null),
        )
    }
}
