@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.scheduler.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property quota Gets or sets the job collection quota.
 * @property sku Gets or sets the SKU.
 * @property state Gets or sets the state.
 */
public data class JobCollectionPropertiesResponse(
    public val quota: JobCollectionQuotaResponse? = null,
    public val sku: SkuResponse? = null,
    public val state: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.scheduler.outputs.JobCollectionPropertiesResponse): JobCollectionPropertiesResponse = JobCollectionPropertiesResponse(
            quota = javaType.quota().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.scheduler.kotlin.outputs.JobCollectionQuotaResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            sku = javaType.sku().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.scheduler.kotlin.outputs.SkuResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            state = javaType.state().map({ args0 -> args0 }).orElse(null),
        )
    }
}
