@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.scheduler.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property action Gets or sets the job action.
 * @property recurrence Gets or sets the job recurrence.
 * @property startTime Gets or sets the job start time.
 * @property state Gets or set the job state.
 * @property status Gets the job status.
 */
public data class JobPropertiesResponse(
    public val action: JobActionResponse? = null,
    public val recurrence: JobRecurrenceResponse? = null,
    public val startTime: String? = null,
    public val state: String? = null,
    public val status: JobStatusResponse,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.scheduler.outputs.JobPropertiesResponse): JobPropertiesResponse = JobPropertiesResponse(
            action = javaType.action().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.scheduler.kotlin.outputs.JobActionResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            recurrence = javaType.recurrence().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.scheduler.kotlin.outputs.JobRecurrenceResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            startTime = javaType.startTime().map({ args0 -> args0 }).orElse(null),
            state = javaType.state().map({ args0 -> args0 }).orElse(null),
            status = javaType.status().let({ args0 ->
                com.pulumi.azurenative.scheduler.kotlin.outputs.JobStatusResponse.Companion.toKotlin(args0)
            }),
        )
    }
}
