@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.scheduler.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property count Gets or sets the maximum number of times that the job should run.
 * @property endTime Gets or sets the time at which the job will complete.
 * @property frequency Gets or sets the frequency of recurrence (second, minute, hour, day, week, month).
 * @property interval Gets or sets the interval between retries.
 * @property schedule
 */
public data class JobRecurrenceResponse(
    public val count: Int? = null,
    public val endTime: String? = null,
    public val frequency: String? = null,
    public val interval: Int? = null,
    public val schedule: JobRecurrenceScheduleResponse? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.scheduler.outputs.JobRecurrenceResponse): JobRecurrenceResponse = JobRecurrenceResponse(
            count = javaType.count().map({ args0 -> args0 }).orElse(null),
            endTime = javaType.endTime().map({ args0 -> args0 }).orElse(null),
            frequency = javaType.frequency().map({ args0 -> args0 }).orElse(null),
            interval = javaType.interval().map({ args0 -> args0 }).orElse(null),
            schedule = javaType.schedule().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.scheduler.kotlin.outputs.JobRecurrenceScheduleResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
